/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.ByteArrayDecoder;
import org.springframework.core.codec.ByteArrayEncoder;
import org.springframework.core.codec.ByteBufferDecoder;
import org.springframework.core.codec.ByteBufferEncoder;
import org.springframework.core.codec.CharSequenceEncoder;
import org.springframework.core.codec.DataBufferDecoder;
import org.springframework.core.codec.DataBufferEncoder;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.codec.ResourceDecoder;
import org.springframework.core.codec.StringDecoder;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.http.codec.DecoderHttpMessageReader;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.ResourceHttpMessageWriter;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.http.codec.xml.Jaxb2XmlDecoder;
import org.springframework.http.codec.xml.Jaxb2XmlEncoder;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

abstract class AbstractCodecConfigurer
implements CodecConfigurer {
    protected static final boolean jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)AbstractCodecConfigurer.class.getClassLoader()) && ClassUtils.isPresent((String)"com.fasterxml.jackson.core.JsonGenerator", (ClassLoader)AbstractCodecConfigurer.class.getClassLoader());
    protected static final boolean jaxb2Present = ClassUtils.isPresent((String)"javax.xml.bind.Binder", (ClassLoader)AbstractCodecConfigurer.class.getClassLoader());
    private final AbstractDefaultCodecs defaultCodecs;
    private final DefaultCustomCodecs customCodecs = new DefaultCustomCodecs();

    protected AbstractCodecConfigurer(AbstractDefaultCodecs defaultCodecs) {
        Assert.notNull((Object)defaultCodecs, (String)"'defaultCodecs' is required.");
        this.defaultCodecs = defaultCodecs;
        this.defaultCodecs.setCustomCodecs(this.customCodecs);
    }

    @Override
    public CodecConfigurer.DefaultCodecs defaultCodecs() {
        return this.defaultCodecs;
    }

    @Override
    public void registerDefaults(boolean shouldRegister) {
        this.defaultCodecs.setRegisterDefaults(shouldRegister);
    }

    @Override
    public CodecConfigurer.CustomCodecs customCodecs() {
        return this.customCodecs;
    }

    @Override
    public List<HttpMessageReader<?>> getReaders() {
        ArrayList result = new ArrayList();
        result.addAll(this.defaultCodecs.getTypedReaders());
        result.addAll(this.customCodecs.getTypedReaders());
        result.addAll(this.defaultCodecs.getObjectReaders());
        result.addAll(this.customCodecs.getObjectReaders());
        result.addAll(this.defaultCodecs.getCatchAllReaders());
        return result;
    }

    @Override
    public List<HttpMessageWriter<?>> getWriters() {
        ArrayList result = new ArrayList();
        result.addAll(this.defaultCodecs.getTypedWriters());
        result.addAll(this.customCodecs.getTypedWriters());
        result.addAll(this.defaultCodecs.getObjectWriters());
        result.addAll(this.customCodecs.getObjectWriters());
        result.addAll(this.defaultCodecs.getCatchAllWriters());
        return result;
    }

    protected static class DefaultCustomCodecs
    implements CodecConfigurer.CustomCodecs {
        private final List<HttpMessageReader<?>> typedReaders = new ArrayList();
        private final List<HttpMessageWriter<?>> typedWriters = new ArrayList();
        private final List<HttpMessageReader<?>> objectReaders = new ArrayList();
        private final List<HttpMessageWriter<?>> objectWriters = new ArrayList();

        protected DefaultCustomCodecs() {
        }

        @Override
        public void decoder(Decoder<?> decoder) {
            this.reader(new DecoderHttpMessageReader(decoder));
        }

        @Override
        public void encoder(Encoder<?> encoder) {
            this.writer(new EncoderHttpMessageWriter(encoder));
        }

        @Override
        public void reader(HttpMessageReader<?> reader) {
            boolean canReadToObject = reader.canRead(ResolvableType.forClass(Object.class), null);
            (canReadToObject ? this.objectReaders : this.typedReaders).add(reader);
        }

        @Override
        public void writer(HttpMessageWriter<?> writer) {
            boolean canWriteObject = writer.canWrite(ResolvableType.forClass(Object.class), null);
            (canWriteObject ? this.objectWriters : this.typedWriters).add(writer);
        }

        public List<HttpMessageReader<?>> getTypedReaders() {
            return this.typedReaders;
        }

        public List<HttpMessageWriter<?>> getTypedWriters() {
            return this.typedWriters;
        }

        public List<HttpMessageReader<?>> getObjectReaders() {
            return this.objectReaders;
        }

        public List<HttpMessageWriter<?>> getObjectWriters() {
            return this.objectWriters;
        }
    }

    protected static abstract class AbstractDefaultCodecs
    implements CodecConfigurer.DefaultCodecs {
        private boolean registerDefaults = true;
        private Jackson2JsonDecoder jackson2Decoder;
        private Jackson2JsonEncoder jackson2Encoder;
        private DefaultCustomCodecs customCodecs;

        protected AbstractDefaultCodecs() {
        }

        public void setRegisterDefaults(boolean registerDefaults) {
            this.registerDefaults = registerDefaults;
        }

        public boolean shouldRegisterDefaults() {
            return this.registerDefaults;
        }

        public void setCustomCodecs(DefaultCustomCodecs customCodecs) {
            this.customCodecs = customCodecs;
        }

        public DefaultCustomCodecs getCustomCodecs() {
            return this.customCodecs;
        }

        @Override
        public void jackson2Decoder(Jackson2JsonDecoder decoder) {
            this.jackson2Decoder = decoder;
        }

        protected Jackson2JsonDecoder jackson2Decoder() {
            return this.jackson2Decoder != null ? this.jackson2Decoder : new Jackson2JsonDecoder();
        }

        @Override
        public void jackson2Encoder(Jackson2JsonEncoder encoder) {
            this.jackson2Encoder = encoder;
        }

        protected Jackson2JsonEncoder jackson2Encoder() {
            return this.jackson2Encoder != null ? this.jackson2Encoder : new Jackson2JsonEncoder();
        }

        public List<HttpMessageReader<?>> getTypedReaders() {
            if (!this.registerDefaults) {
                return Collections.emptyList();
            }
            ArrayList result = new ArrayList();
            result.add(new DecoderHttpMessageReader(new ByteArrayDecoder()));
            result.add(new DecoderHttpMessageReader(new ByteBufferDecoder()));
            result.add(new DecoderHttpMessageReader(new DataBufferDecoder()));
            result.add(new DecoderHttpMessageReader(new ResourceDecoder()));
            result.add(new DecoderHttpMessageReader(StringDecoder.textPlainOnly((boolean)this.splitTextOnNewLine())));
            return result;
        }

        protected abstract boolean splitTextOnNewLine();

        public List<HttpMessageReader<?>> getObjectReaders() {
            if (!this.registerDefaults) {
                return Collections.emptyList();
            }
            ArrayList result = new ArrayList();
            if (jaxb2Present) {
                result.add(new DecoderHttpMessageReader(new Jaxb2XmlDecoder()));
            }
            if (jackson2Present) {
                result.add(new DecoderHttpMessageReader<Object>(this.jackson2Decoder()));
            }
            return result;
        }

        public List<HttpMessageReader<?>> getCatchAllReaders() {
            if (!this.registerDefaults) {
                return Collections.emptyList();
            }
            ArrayList result = new ArrayList();
            result.add(new DecoderHttpMessageReader(StringDecoder.allMimeTypes((boolean)this.splitTextOnNewLine())));
            return result;
        }

        public List<HttpMessageWriter<?>> getTypedWriters() {
            if (!this.registerDefaults) {
                return Collections.emptyList();
            }
            ArrayList result = new ArrayList();
            result.add(new EncoderHttpMessageWriter(new ByteArrayEncoder()));
            result.add(new EncoderHttpMessageWriter(new ByteBufferEncoder()));
            result.add(new EncoderHttpMessageWriter(new DataBufferEncoder()));
            result.add(new ResourceHttpMessageWriter());
            result.add(new EncoderHttpMessageWriter(CharSequenceEncoder.textPlainOnly()));
            return result;
        }

        public List<HttpMessageWriter<?>> getObjectWriters() {
            if (!this.registerDefaults) {
                return Collections.emptyList();
            }
            ArrayList result = new ArrayList();
            if (jaxb2Present) {
                result.add(new EncoderHttpMessageWriter(new Jaxb2XmlEncoder()));
            }
            if (jackson2Present) {
                result.add(new EncoderHttpMessageWriter<Object>(this.jackson2Encoder()));
            }
            return result;
        }

        public List<HttpMessageWriter<?>> getCatchAllWriters() {
            if (!this.registerDefaults) {
                return Collections.emptyList();
            }
            ArrayList result = new ArrayList();
            result.add(new EncoderHttpMessageWriter(CharSequenceEncoder.allMimeTypes()));
            return result;
        }
    }
}

