/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.core.CollectionFactory;
import org.springframework.lang.Nullable;
import org.springframework.validation.DataBinder;
import org.springframework.web.multipart.MultipartFile;

public class WebDataBinder
extends DataBinder {
    public static final String DEFAULT_FIELD_MARKER_PREFIX = "_";
    public static final String DEFAULT_FIELD_DEFAULT_PREFIX = "!";
    private String fieldMarkerPrefix = "_";
    private String fieldDefaultPrefix = "!";
    private boolean bindEmptyMultipartFiles = true;

    public WebDataBinder(@Nullable Object target) {
        super(target);
    }

    public WebDataBinder(@Nullable Object target, @Nullable String objectName) {
        super(target, objectName);
    }

    public void setFieldMarkerPrefix(String fieldMarkerPrefix) {
        this.fieldMarkerPrefix = fieldMarkerPrefix;
    }

    @Nullable
    public String getFieldMarkerPrefix() {
        return this.fieldMarkerPrefix;
    }

    public void setFieldDefaultPrefix(String fieldDefaultPrefix) {
        this.fieldDefaultPrefix = fieldDefaultPrefix;
    }

    @Nullable
    public String getFieldDefaultPrefix() {
        return this.fieldDefaultPrefix;
    }

    public void setBindEmptyMultipartFiles(boolean bindEmptyMultipartFiles) {
        this.bindEmptyMultipartFiles = bindEmptyMultipartFiles;
    }

    public boolean isBindEmptyMultipartFiles() {
        return this.bindEmptyMultipartFiles;
    }

    protected void doBind(MutablePropertyValues mpvs) {
        this.checkFieldDefaults(mpvs);
        this.checkFieldMarkers(mpvs);
        super.doBind(mpvs);
    }

    protected void checkFieldDefaults(MutablePropertyValues mpvs) {
        if (this.getFieldDefaultPrefix() != null) {
            PropertyValue[] pvArray;
            String fieldDefaultPrefix = this.getFieldDefaultPrefix();
            for (PropertyValue pv : pvArray = mpvs.getPropertyValues()) {
                if (!pv.getName().startsWith(fieldDefaultPrefix)) continue;
                String field = pv.getName().substring(fieldDefaultPrefix.length());
                if (this.getPropertyAccessor().isWritableProperty(field) && !mpvs.contains(field)) {
                    mpvs.add(field, pv.getValue());
                }
                mpvs.removePropertyValue(pv);
            }
        }
    }

    protected void checkFieldMarkers(MutablePropertyValues mpvs) {
        if (this.getFieldMarkerPrefix() != null) {
            PropertyValue[] pvArray;
            String fieldMarkerPrefix = this.getFieldMarkerPrefix();
            for (PropertyValue pv : pvArray = mpvs.getPropertyValues()) {
                if (!pv.getName().startsWith(fieldMarkerPrefix)) continue;
                String field = pv.getName().substring(fieldMarkerPrefix.length());
                if (this.getPropertyAccessor().isWritableProperty(field) && !mpvs.contains(field)) {
                    Class fieldType = this.getPropertyAccessor().getPropertyType(field);
                    mpvs.add(field, this.getEmptyValue(field, fieldType));
                }
                mpvs.removePropertyValue(pv);
            }
        }
    }

    @Nullable
    protected Object getEmptyValue(String field, @Nullable Class<?> fieldType) {
        if (fieldType != null) {
            try {
                if (Boolean.TYPE == fieldType || Boolean.class == fieldType) {
                    return Boolean.FALSE;
                }
                if (fieldType.isArray()) {
                    return Array.newInstance(fieldType.getComponentType(), 0);
                }
                if (Collection.class.isAssignableFrom(fieldType)) {
                    return CollectionFactory.createCollection(fieldType, (int)0);
                }
                if (Map.class.isAssignableFrom(fieldType)) {
                    return CollectionFactory.createMap(fieldType, (int)0);
                }
            }
            catch (IllegalArgumentException exc) {
                return null;
            }
        }
        return null;
    }

    protected void bindMultipart(Map<String, List<MultipartFile>> multipartFiles, MutablePropertyValues mpvs) {
        for (Map.Entry<String, List<MultipartFile>> entry : multipartFiles.entrySet()) {
            String key = entry.getKey();
            List<MultipartFile> values = entry.getValue();
            if (values.size() == 1) {
                MultipartFile value = values.get(0);
                if (!this.isBindEmptyMultipartFiles() && value.isEmpty()) continue;
                mpvs.add(key, (Object)value);
                continue;
            }
            mpvs.add(key, values);
        }
    }
}

