/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.server.adapter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.server.WebExceptionHandler;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebHandler;
import org.springframework.web.server.adapter.HttpWebHandlerAdapter;
import org.springframework.web.server.handler.ExceptionHandlingWebHandler;
import org.springframework.web.server.handler.FilteringWebHandler;
import org.springframework.web.server.handler.WebHandlerDecorator;
import org.springframework.web.server.i18n.LocaleContextResolver;
import org.springframework.web.server.session.WebSessionManager;

public class WebHttpHandlerBuilder {
    public static final String WEB_HANDLER_BEAN_NAME = "webHandler";
    public static final String WEB_SESSION_MANAGER_BEAN_NAME = "webSessionManager";
    public static final String SERVER_CODEC_CONFIGURER_BEAN_NAME = "serverCodecConfigurer";
    public static final String LOCALE_CONTEXT_RESOLVER_BEAN_NAME = "localeContextResolver";
    private final WebHandler webHandler;
    private final List<WebFilter> filters = new ArrayList<WebFilter>();
    private final List<WebExceptionHandler> exceptionHandlers = new ArrayList<WebExceptionHandler>();
    private WebSessionManager sessionManager;
    private ServerCodecConfigurer codecConfigurer;
    private LocaleContextResolver localeContextResolver;

    private WebHttpHandlerBuilder(WebHandler webHandler) {
        Assert.notNull((Object)webHandler, (String)"WebHandler must not be null");
        this.webHandler = webHandler;
    }

    public static WebHttpHandlerBuilder webHandler(WebHandler webHandler) {
        return new WebHttpHandlerBuilder(webHandler);
    }

    public static WebHttpHandlerBuilder applicationContext(ApplicationContext context) {
        WebHttpHandlerBuilder builder = new WebHttpHandlerBuilder((WebHandler)context.getBean(WEB_HANDLER_BEAN_NAME, WebHandler.class));
        SortedBeanContainer container = new SortedBeanContainer();
        context.getAutowireCapableBeanFactory().autowireBean((Object)container);
        builder.filters(container.getFilters());
        builder.exceptionHandlers(container.getExceptionHandlers());
        try {
            builder.sessionManager((WebSessionManager)context.getBean(WEB_SESSION_MANAGER_BEAN_NAME, WebSessionManager.class));
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        try {
            builder.codecConfigurer((ServerCodecConfigurer)context.getBean(SERVER_CODEC_CONFIGURER_BEAN_NAME, ServerCodecConfigurer.class));
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        try {
            builder.localeContextResolver((LocaleContextResolver)context.getBean(LOCALE_CONTEXT_RESOLVER_BEAN_NAME, LocaleContextResolver.class));
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        return builder;
    }

    public WebHttpHandlerBuilder filter(WebFilter ... filters) {
        if (!ObjectUtils.isEmpty((Object[])filters)) {
            this.filters.addAll(Arrays.asList(filters));
        }
        return this;
    }

    public WebHttpHandlerBuilder filters(List<? extends WebFilter> filters) {
        if (!ObjectUtils.isEmpty(filters)) {
            this.filters.addAll(filters);
        }
        return this;
    }

    public WebHttpHandlerBuilder prependFilter(WebFilter filter) {
        Assert.notNull((Object)filter, (String)"WebFilter is required");
        this.filters.add(0, filter);
        return this;
    }

    public WebHttpHandlerBuilder exceptionHandler(WebExceptionHandler ... handlers) {
        if (!ObjectUtils.isEmpty((Object[])handlers)) {
            this.exceptionHandlers.addAll(Arrays.asList(handlers));
        }
        return this;
    }

    public WebHttpHandlerBuilder exceptionHandlers(List<WebExceptionHandler> handlers) {
        if (!ObjectUtils.isEmpty(handlers)) {
            this.exceptionHandlers.addAll(handlers);
        }
        return this;
    }

    public WebHttpHandlerBuilder prependExceptionHandler(WebExceptionHandler handler) {
        Assert.notNull((Object)handler, (String)"WebExceptionHandler is required");
        this.exceptionHandlers.add(0, handler);
        return this;
    }

    public WebHttpHandlerBuilder sessionManager(WebSessionManager manager) {
        this.sessionManager = manager;
        return this;
    }

    public WebHttpHandlerBuilder codecConfigurer(ServerCodecConfigurer codecConfigurer) {
        this.codecConfigurer = codecConfigurer;
        return this;
    }

    public WebHttpHandlerBuilder localeContextResolver(LocaleContextResolver localeContextResolver) {
        this.localeContextResolver = localeContextResolver;
        return this;
    }

    public HttpHandler build() {
        WebHandlerDecorator decorated = new FilteringWebHandler(this.webHandler, this.filters);
        decorated = new ExceptionHandlingWebHandler(decorated, this.exceptionHandlers);
        HttpWebHandlerAdapter adapted = new HttpWebHandlerAdapter(decorated);
        if (this.sessionManager != null) {
            adapted.setSessionManager(this.sessionManager);
        }
        if (this.codecConfigurer != null) {
            adapted.setCodecConfigurer(this.codecConfigurer);
        }
        if (this.localeContextResolver != null) {
            adapted.setLocaleContextResolver(this.localeContextResolver);
        }
        return adapted;
    }

    private static class SortedBeanContainer {
        private List<WebFilter> filters;
        private List<WebExceptionHandler> exceptionHandlers;

        private SortedBeanContainer() {
        }

        @Autowired(required=false)
        public void setFilters(List<WebFilter> filters) {
            this.filters = filters;
        }

        public List<WebFilter> getFilters() {
            return this.filters;
        }

        @Autowired(required=false)
        public void setExceptionHandlers(List<WebExceptionHandler> exceptionHandlers) {
            this.exceptionHandlers = exceptionHandlers;
        }

        public List<WebExceptionHandler> getExceptionHandlers() {
            return this.exceptionHandlers;
        }
    }
}

