/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util.pattern;

import org.springframework.web.util.pattern.PathElement;
import org.springframework.web.util.pattern.PathPattern;

class LiteralPathElement
extends PathElement {
    private char[] text;
    private int len;
    private boolean caseSensitive;

    public LiteralPathElement(int pos, char[] literalText, boolean caseSensitive, char separator) {
        super(pos, separator);
        this.len = literalText.length;
        this.caseSensitive = caseSensitive;
        if (caseSensitive) {
            this.text = literalText;
        } else {
            this.text = new char[literalText.length];
            for (int i = 0; i < this.len; ++i) {
                this.text[i] = Character.toLowerCase(literalText[i]);
            }
        }
    }

    @Override
    public boolean matches(int candidateIndex, PathPattern.MatchingContext matchingContext) {
        if (candidateIndex + this.text.length > matchingContext.candidateLength) {
            return false;
        }
        if (this.caseSensitive) {
            for (int i = 0; i < this.len; ++i) {
                if (matchingContext.candidate[candidateIndex++] == this.text[i] || i >= 3 && matchingContext.candidate[candidateIndex - 3] == '%' && Character.toUpperCase(matchingContext.candidate[candidateIndex - 1]) == this.text[i]) continue;
                return false;
            }
        } else {
            for (int i = 0; i < this.len; ++i) {
                if (Character.toLowerCase(matchingContext.candidate[candidateIndex++]) == this.text[i]) continue;
                return false;
            }
        }
        if (this.next == null) {
            if (matchingContext.determineRemainingPath && this.nextIfExistsIsSeparator(candidateIndex, matchingContext)) {
                matchingContext.remainingPathIndex = candidateIndex;
                return true;
            }
            if (candidateIndex == matchingContext.candidateLength) {
                return true;
            }
            return matchingContext.isAllowOptionalTrailingSlash() && candidateIndex + 1 == matchingContext.candidateLength && matchingContext.candidate[candidateIndex] == this.separator;
        }
        if (matchingContext.isMatchStartMatching && candidateIndex == matchingContext.candidateLength) {
            return true;
        }
        return this.next.matches(candidateIndex, matchingContext);
    }

    @Override
    public int getNormalizedLength() {
        return this.len;
    }

    public String toString() {
        return "Literal(" + String.valueOf(this.text) + ")";
    }
}

