/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util.pattern;

import org.springframework.web.util.pattern.PathElement;
import org.springframework.web.util.pattern.PathPattern;

class SingleCharWildcardedPathElement
extends PathElement {
    private final char[] text;
    private final int len;
    private final int questionMarkCount;
    private final boolean caseSensitive;

    public SingleCharWildcardedPathElement(int pos, char[] literalText, int questionMarkCount, boolean caseSensitive, char separator) {
        super(pos, separator);
        this.len = literalText.length;
        this.questionMarkCount = questionMarkCount;
        this.caseSensitive = caseSensitive;
        if (caseSensitive) {
            this.text = literalText;
        } else {
            this.text = new char[literalText.length];
            for (int i = 0; i < this.len; ++i) {
                this.text[i] = Character.toLowerCase(literalText[i]);
            }
        }
    }

    @Override
    public boolean matches(int candidateIndex, PathPattern.MatchingContext matchingContext) {
        if (matchingContext.candidateLength < candidateIndex + this.len) {
            return false;
        }
        char[] candidate = matchingContext.candidate;
        if (this.caseSensitive) {
            for (int i = 0; i < this.len; ++i) {
                char t = this.text[i];
                if (t == '?') {
                    if (candidate[candidateIndex] == '%') {
                        candidateIndex += 2;
                    }
                } else if (candidate[candidateIndex] != t && (i < 3 || matchingContext.candidate[candidateIndex - 2] != '%' || Character.toUpperCase(matchingContext.candidate[candidateIndex]) != this.text[i])) {
                    return false;
                }
                ++candidateIndex;
            }
        } else {
            for (int i = 0; i < this.len; ++i) {
                char t = this.text[i];
                if (t == '?') {
                    if (candidate[candidateIndex] == '%') {
                        candidateIndex += 2;
                    }
                } else if (Character.toLowerCase(candidate[candidateIndex]) != t) {
                    return false;
                }
                ++candidateIndex;
            }
        }
        if (this.next == null) {
            if (matchingContext.determineRemainingPath && this.nextIfExistsIsSeparator(candidateIndex, matchingContext)) {
                matchingContext.remainingPathIndex = candidateIndex;
                return true;
            }
            if (candidateIndex == matchingContext.candidateLength) {
                return true;
            }
            return matchingContext.isAllowOptionalTrailingSlash() && candidateIndex + 1 == matchingContext.candidateLength && matchingContext.candidate[candidateIndex] == this.separator;
        }
        if (matchingContext.isMatchStartMatching && candidateIndex == matchingContext.candidateLength) {
            return true;
        }
        return this.next.matches(candidateIndex, matchingContext);
    }

    @Override
    public int getWildcardCount() {
        return this.questionMarkCount;
    }

    @Override
    public int getNormalizedLength() {
        return this.len;
    }

    public String toString() {
        return "SingleCharWildcarded(" + String.valueOf(this.text) + ")";
    }
}

