/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.service.invoker;

import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.SynthesizingMethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;
import org.springframework.web.service.annotation.HttpExchange;
import org.springframework.web.service.invoker.HttpClientAdapter;
import org.springframework.web.service.invoker.HttpRequestValues;
import org.springframework.web.service.invoker.HttpServiceArgumentResolver;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class HttpServiceMethod {
    private final Method method;
    private final MethodParameter[] parameters;
    private final List<HttpServiceArgumentResolver> argumentResolvers;
    private final HttpRequestValuesInitializer requestValuesInitializer;
    private final ResponseFunction responseFunction;

    HttpServiceMethod(Method method, Class<?> containingClass, List<HttpServiceArgumentResolver> argumentResolvers, HttpClientAdapter client, @Nullable StringValueResolver embeddedValueResolver, ReactiveAdapterRegistry reactiveRegistry, Duration blockTimeout) {
        this.method = method;
        this.parameters = HttpServiceMethod.initMethodParameters(method);
        this.argumentResolvers = argumentResolvers;
        this.requestValuesInitializer = HttpRequestValuesInitializer.create(method, containingClass, embeddedValueResolver);
        this.responseFunction = ResponseFunction.create(client, method, reactiveRegistry, blockTimeout);
    }

    private static MethodParameter[] initMethodParameters(Method method) {
        int count = method.getParameterCount();
        if (count == 0) {
            return new MethodParameter[0];
        }
        if (KotlinDetector.isSuspendingFunction((Method)method)) {
            --count;
        }
        DefaultParameterNameDiscoverer nameDiscoverer = new DefaultParameterNameDiscoverer();
        MethodParameter[] parameters = new MethodParameter[count];
        for (int i = 0; i < count; ++i) {
            parameters[i] = new SynthesizingMethodParameter(method, i);
            parameters[i].initParameterNameDiscovery((ParameterNameDiscoverer)nameDiscoverer);
        }
        return parameters;
    }

    public Method getMethod() {
        return this.method;
    }

    @Nullable
    public Object invoke(Object[] arguments) {
        HttpRequestValues.Builder requestValues = this.requestValuesInitializer.initializeRequestValuesBuilder();
        this.applyArguments(requestValues, arguments);
        return this.responseFunction.execute(requestValues.build());
    }

    private void applyArguments(HttpRequestValues.Builder requestValues, Object[] arguments) {
        Assert.isTrue((arguments.length == this.parameters.length ? 1 : 0) != 0, (String)"Method argument mismatch");
        int i = 0;
        while (i < arguments.length) {
            Object value = arguments[i];
            boolean resolved = false;
            for (HttpServiceArgumentResolver resolver : this.argumentResolvers) {
                if (!resolver.resolve(value, this.parameters[i], requestValues)) continue;
                resolved = true;
                break;
            }
            int index = i++;
            Assert.state((boolean)resolved, () -> HttpServiceMethod.formatArgumentError(this.parameters[index], "No suitable resolver"));
        }
    }

    private static String formatArgumentError(MethodParameter param, String message) {
        return "Could not resolve parameter [" + param.getParameterIndex() + "] in " + param.getExecutable().toGenericString() + (String)(StringUtils.hasText((String)message) ? ": " + message : "");
    }

    private record HttpRequestValuesInitializer(@Nullable HttpMethod httpMethod, @Nullable String url, @Nullable MediaType contentType, @Nullable List<MediaType> acceptMediaTypes) {
        public HttpRequestValues.Builder initializeRequestValuesBuilder() {
            HttpRequestValues.Builder requestValues = HttpRequestValues.builder();
            if (this.httpMethod != null) {
                requestValues.setHttpMethod(this.httpMethod);
            }
            if (this.url != null) {
                requestValues.setUriTemplate(this.url);
            }
            if (this.contentType != null) {
                requestValues.setContentType(this.contentType);
            }
            if (this.acceptMediaTypes != null) {
                requestValues.setAccept(this.acceptMediaTypes);
            }
            return requestValues;
        }

        public static HttpRequestValuesInitializer create(Method method, Class<?> containingClass, @Nullable StringValueResolver embeddedValueResolver) {
            HttpExchange annot1 = (HttpExchange)AnnotatedElementUtils.findMergedAnnotation(containingClass, HttpExchange.class);
            HttpExchange annot2 = (HttpExchange)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, HttpExchange.class);
            Assert.notNull((Object)annot2, (String)"Expected HttpRequest annotation");
            HttpMethod httpMethod = HttpRequestValuesInitializer.initHttpMethod(annot1, annot2);
            String url = HttpRequestValuesInitializer.initUrl(annot1, annot2, embeddedValueResolver);
            MediaType contentType = HttpRequestValuesInitializer.initContentType(annot1, annot2);
            List<MediaType> acceptableMediaTypes = HttpRequestValuesInitializer.initAccept(annot1, annot2);
            return new HttpRequestValuesInitializer(httpMethod, url, contentType, acceptableMediaTypes);
        }

        @Nullable
        private static HttpMethod initHttpMethod(@Nullable HttpExchange typeAnnot, HttpExchange annot) {
            String value1 = typeAnnot != null ? typeAnnot.method() : null;
            String value2 = annot.method();
            if (StringUtils.hasText((String)value2)) {
                return HttpMethod.valueOf(value2);
            }
            if (StringUtils.hasText((String)value1)) {
                return HttpMethod.valueOf(value1);
            }
            return null;
        }

        @Nullable
        private static String initUrl(@Nullable HttpExchange typeAnnot, HttpExchange annot, @Nullable StringValueResolver embeddedValueResolver) {
            String url1 = typeAnnot != null ? typeAnnot.url() : null;
            String url2 = annot.url();
            if (embeddedValueResolver != null) {
                url1 = url1 != null ? embeddedValueResolver.resolveStringValue(url1) : null;
                url2 = embeddedValueResolver.resolveStringValue(url2);
            }
            boolean hasUrl1 = StringUtils.hasText((String)url1);
            boolean hasUrl2 = StringUtils.hasText((String)url2);
            if (hasUrl1 && hasUrl2) {
                return url1 + (!url1.endsWith("/") && !url2.startsWith("/") ? "/" : "") + url2;
            }
            if (!hasUrl1 && !hasUrl2) {
                return null;
            }
            return hasUrl2 ? url2 : url1;
        }

        @Nullable
        private static MediaType initContentType(@Nullable HttpExchange typeAnnot, HttpExchange annot) {
            String value1 = typeAnnot != null ? typeAnnot.contentType() : null;
            String value2 = annot.contentType();
            if (StringUtils.hasText((String)value2)) {
                return MediaType.parseMediaType(value2);
            }
            if (StringUtils.hasText((String)value1)) {
                return MediaType.parseMediaType(value1);
            }
            return null;
        }

        @Nullable
        private static List<MediaType> initAccept(@Nullable HttpExchange typeAnnot, HttpExchange annot) {
            Object[] value1 = typeAnnot != null ? typeAnnot.accept() : null;
            Object[] value2 = annot.accept();
            if (!ObjectUtils.isEmpty((Object[])value2)) {
                return MediaType.parseMediaTypes(Arrays.asList(value2));
            }
            if (!ObjectUtils.isEmpty((Object[])value1)) {
                return MediaType.parseMediaTypes(Arrays.asList(value1));
            }
            return null;
        }
    }

    private record ResponseFunction(Function<HttpRequestValues, Publisher<?>> responseFunction, @Nullable ReactiveAdapter returnTypeAdapter, boolean blockForOptional, Duration blockTimeout) {
        @Nullable
        public Object execute(HttpRequestValues requestValues) {
            Publisher<?> responsePublisher = this.responseFunction.apply(requestValues);
            if (this.returnTypeAdapter != null) {
                return this.returnTypeAdapter.fromPublisher(responsePublisher);
            }
            return this.blockForOptional ? ((Mono)responsePublisher).blockOptional(this.blockTimeout) : ((Mono)responsePublisher).block(this.blockTimeout);
        }

        /*
         * Unable to fully structure code
         */
        public static ResponseFunction create(HttpClientAdapter client, Method method, ReactiveAdapterRegistry reactiveRegistry, Duration blockTimeout) {
            returnParam = new MethodParameter(method, -1);
            returnType = returnParam.getParameterType();
            if (KotlinDetector.isSuspendingFunction((Method)method)) {
                returnType = Mono.class;
            }
            if ((actualType = (actualParam = (reactiveAdapter = reactiveRegistry.getAdapter(returnType)) != null ? returnParam.nested() : returnParam.nestedIfOptional()).getNestedParameterType()).equals(Void.TYPE)) ** GOTO lbl10
            if (actualType.equals(Void.class)) {
lbl10:
                // 2 sources

                responseFunction = (Function<HttpRequestValues, Publisher<?>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, requestToVoid(org.springframework.web.service.invoker.HttpRequestValues ), (Lorg/springframework/web/service/invoker/HttpRequestValues;)Lorg/reactivestreams/Publisher;)((HttpClientAdapter)client);
            } else if (reactiveAdapter != null && reactiveAdapter.isNoValue()) {
                responseFunction = (Function<HttpRequestValues, Publisher>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, requestToVoid(org.springframework.web.service.invoker.HttpRequestValues ), (Lorg/springframework/web/service/invoker/HttpRequestValues;)Lorg/reactivestreams/Publisher;)((HttpClientAdapter)client);
            } else if (actualType.equals(HttpHeaders.class)) {
                responseFunction = (Function<HttpRequestValues, Publisher>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, requestToHeaders(org.springframework.web.service.invoker.HttpRequestValues ), (Lorg/springframework/web/service/invoker/HttpRequestValues;)Lorg/reactivestreams/Publisher;)((HttpClientAdapter)client);
            } else if (actualType.equals(ResponseEntity.class)) {
                bodyParam = actualParam.nested();
                bodyType = bodyParam.getNestedParameterType();
                if (bodyType.equals(Void.class)) {
                    responseFunction = (Function<HttpRequestValues, Publisher>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, requestToBodilessEntity(org.springframework.web.service.invoker.HttpRequestValues ), (Lorg/springframework/web/service/invoker/HttpRequestValues;)Lorg/reactivestreams/Publisher;)((HttpClientAdapter)client);
                } else {
                    bodyAdapter = reactiveRegistry.getAdapter(bodyType);
                    responseFunction = ResponseFunction.initResponseEntityFunction(client, bodyParam, bodyAdapter);
                }
            } else {
                responseFunction = ResponseFunction.initBodyFunction(client, actualParam, reactiveAdapter);
            }
            blockForOptional = returnType.equals(Optional.class);
            return new ResponseFunction(responseFunction, reactiveAdapter, blockForOptional, blockTimeout);
        }

        private static Function<HttpRequestValues, Publisher<?>> initResponseEntityFunction(HttpClientAdapter client, MethodParameter methodParam, @Nullable ReactiveAdapter reactiveAdapter) {
            if (reactiveAdapter == null) {
                return request -> client.requestToEntity((HttpRequestValues)request, ParameterizedTypeReference.forType((Type)methodParam.getNestedGenericParameterType()));
            }
            Assert.isTrue((boolean)reactiveAdapter.isMultiValue(), (String)"ResponseEntity body must be a concrete value or a multi-value Publisher");
            ParameterizedTypeReference bodyType = ParameterizedTypeReference.forType((Type)methodParam.nested().getNestedGenericParameterType());
            if (reactiveAdapter.getReactiveType().equals(Flux.class)) {
                return request -> client.requestToEntityFlux((HttpRequestValues)request, bodyType);
            }
            return request -> client.requestToEntityFlux((HttpRequestValues)request, bodyType).map(entity -> {
                Object body = reactiveAdapter.fromPublisher((Publisher)entity.getBody());
                return new ResponseEntity<Object>(body, (MultiValueMap<String, String>)entity.getHeaders(), entity.getStatusCode());
            });
        }

        private static Function<HttpRequestValues, Publisher<?>> initBodyFunction(HttpClientAdapter client, MethodParameter methodParam, @Nullable ReactiveAdapter reactiveAdapter) {
            ParameterizedTypeReference bodyType = ParameterizedTypeReference.forType((Type)methodParam.getNestedGenericParameterType());
            return reactiveAdapter != null && reactiveAdapter.isMultiValue() ? request -> client.requestToBodyFlux((HttpRequestValues)request, bodyType) : request -> client.requestToBody((HttpRequestValues)request, bodyType);
        }
    }
}

