/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.observation;

import io.micrometer.observation.transport.Propagator;
import io.micrometer.observation.transport.RequestReplyReceiverContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collections;
import org.jspecify.annotations.Nullable;

public class ServerRequestObservationContext
extends RequestReplyReceiverContext<HttpServletRequest, HttpServletResponse> {
    private static final HeaderGetter GETTER = new HeaderGetter();
    private @Nullable String pathPattern;

    public ServerRequestObservationContext(HttpServletRequest request, HttpServletResponse response) {
        super((Propagator.Getter)GETTER);
        this.setCarrier(request);
        this.setResponse(response);
    }

    public @Nullable String getPathPattern() {
        return this.pathPattern;
    }

    public void setPathPattern(@Nullable String pathPattern) {
        this.pathPattern = pathPattern;
    }

    static final class HeaderGetter
    implements Propagator.Getter<HttpServletRequest> {
        HeaderGetter() {
        }

        public String get(HttpServletRequest carrier, String key) {
            return carrier.getHeader(key);
        }

        public Iterable<String> getAll(HttpServletRequest carrier, String key) {
            return Collections.list(carrier.getHeaders(key));
        }
    }
}

