/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.config;

import java.util.Map;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.webflow.config.FlowSystemDefaults;
import org.springframework.webflow.config.RepositoryType;
import org.springframework.webflow.conversation.ConversationManager;
import org.springframework.webflow.conversation.impl.SessionBindingConversationManager;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.registry.FlowDefinitionLocator;
import org.springframework.webflow.engine.impl.FlowExecutionImplFactory;
import org.springframework.webflow.engine.impl.FlowExecutionImplStateRestorer;
import org.springframework.webflow.execution.FlowExecutionFactory;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.factory.FlowExecutionListenerLoader;
import org.springframework.webflow.execution.factory.StaticFlowExecutionListenerLoader;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.execution.repository.continuation.ClientContinuationFlowExecutionRepository;
import org.springframework.webflow.execution.repository.continuation.ContinuationFlowExecutionRepository;
import org.springframework.webflow.execution.repository.support.FlowExecutionStateRestorer;
import org.springframework.webflow.execution.repository.support.SimpleFlowExecutionRepository;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.executor.FlowExecutorImpl;

public class FlowExecutorFactoryBean
implements FactoryBean,
InitializingBean {
    private FlowDefinitionLocator definitionLocator;
    private MutableAttributeMap executionAttributes;
    private FlowExecutionListenerLoader executionListenerLoader;
    private ConversationManager conversationManager;
    private Integer maxConversations;
    private RepositoryType repositoryType;
    private Integer maxContinuations;
    private FlowExecutor flowExecutor;
    private FlowSystemDefaults defaults = new FlowSystemDefaults();
    static /* synthetic */ Class class$org$springframework$webflow$executor$FlowExecutor;

    public void setDefinitionLocator(FlowDefinitionLocator definitionLocator) {
        this.definitionLocator = definitionLocator;
    }

    public void setExecutionAttributes(Map executionAttributes) {
        this.executionAttributes = new LocalAttributeMap(executionAttributes);
    }

    public void setExecutionListener(FlowExecutionListener executionListener) {
        this.setExecutionListeners(new FlowExecutionListener[]{executionListener});
    }

    public void setExecutionListeners(FlowExecutionListener[] executionListeners) {
        this.setExecutionListenerLoader(new StaticFlowExecutionListenerLoader(executionListeners));
    }

    public void setExecutionListenerLoader(FlowExecutionListenerLoader executionListenerLoader) {
        this.executionListenerLoader = executionListenerLoader;
    }

    public void setRepositoryType(RepositoryType repositoryType) {
        this.repositoryType = repositoryType;
    }

    public void setMaxContinuations(int maxContinuations) {
        this.maxContinuations = new Integer(maxContinuations);
    }

    protected Integer getMaxContinuations() {
        return this.maxContinuations;
    }

    public void setConversationManager(ConversationManager conversationManager) {
        this.conversationManager = conversationManager;
    }

    public void setMaxConversations(int maxConversations) {
        this.maxConversations = new Integer(maxConversations);
    }

    protected Integer getMaxConversations() {
        return this.maxConversations;
    }

    public void setDefaults(FlowSystemDefaults defaults) {
        this.defaults = defaults;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.definitionLocator, (String)"The flow definition locator is required");
        this.executionAttributes = this.defaults.applyExecutionAttributes(this.executionAttributes);
        this.repositoryType = this.defaults.applyIfNecessary(this.repositoryType);
        FlowExecutionFactory executionFactory = this.createFlowExecutionFactory(this.executionAttributes, this.executionListenerLoader);
        FlowExecutionStateRestorer executionStateRestorer = this.createFlowExecutionStateRestorer(this.definitionLocator, this.executionAttributes, this.executionListenerLoader);
        FlowExecutionRepository executionRepository = this.createExecutionRepository(this.repositoryType, executionStateRestorer, this.conversationManager);
        this.flowExecutor = this.createFlowExecutor(this.definitionLocator, executionFactory, executionRepository);
    }

    protected ConversationManager createDefaultConversationManager() {
        SessionBindingConversationManager conversationManager = new SessionBindingConversationManager();
        if (this.getMaxConversations() != null) {
            conversationManager.setMaxConversations(this.getMaxConversations());
        }
        return conversationManager;
    }

    protected FlowExecutionFactory createFlowExecutionFactory(AttributeMap executionAttributes, FlowExecutionListenerLoader executionListenerLoader) {
        FlowExecutionImplFactory executionFactory = new FlowExecutionImplFactory();
        executionFactory.setExecutionAttributes(executionAttributes);
        if (executionListenerLoader != null) {
            executionFactory.setExecutionListenerLoader(executionListenerLoader);
        }
        return executionFactory;
    }

    protected FlowExecutionStateRestorer createFlowExecutionStateRestorer(FlowDefinitionLocator definitionLocator, AttributeMap executionAttributes, FlowExecutionListenerLoader executionListenerLoader) {
        FlowExecutionImplStateRestorer executionStateRestorer = new FlowExecutionImplStateRestorer(definitionLocator);
        executionStateRestorer.setExecutionAttributes(executionAttributes);
        if (executionListenerLoader != null) {
            executionStateRestorer.setExecutionListenerLoader(executionListenerLoader);
        }
        return executionStateRestorer;
    }

    protected FlowExecutionRepository createExecutionRepository(RepositoryType repositoryType, FlowExecutionStateRestorer executionStateRestorer, ConversationManager conversationManager) {
        if (repositoryType == RepositoryType.CLIENT) {
            if (conversationManager == null) {
                return new ClientContinuationFlowExecutionRepository(executionStateRestorer);
            }
            return new ClientContinuationFlowExecutionRepository(executionStateRestorer, conversationManager);
        }
        ConversationManager conversationManagerToUse = conversationManager;
        if (conversationManagerToUse == null) {
            conversationManagerToUse = this.createDefaultConversationManager();
        }
        if (repositoryType == RepositoryType.SIMPLE) {
            return new SimpleFlowExecutionRepository(executionStateRestorer, conversationManagerToUse);
        }
        if (repositoryType == RepositoryType.CONTINUATION) {
            ContinuationFlowExecutionRepository repository = new ContinuationFlowExecutionRepository(executionStateRestorer, conversationManagerToUse);
            if (this.getMaxContinuations() != null) {
                repository.setMaxContinuations(this.getMaxContinuations());
            }
            return repository;
        }
        if (repositoryType == RepositoryType.SINGLEKEY) {
            SimpleFlowExecutionRepository repository = new SimpleFlowExecutionRepository(executionStateRestorer, conversationManagerToUse);
            repository.setAlwaysGenerateNewNextKey(false);
            return repository;
        }
        throw new IllegalStateException("Cannot create execution repository - unsupported repository type " + (Object)((Object)repositoryType));
    }

    protected FlowExecutor createFlowExecutor(FlowDefinitionLocator definitionLocator, FlowExecutionFactory executionFactory, FlowExecutionRepository executionRepository) {
        return new FlowExecutorImpl(definitionLocator, executionFactory, executionRepository);
    }

    public Class getObjectType() {
        return class$org$springframework$webflow$executor$FlowExecutor == null ? (class$org$springframework$webflow$executor$FlowExecutor = FlowExecutorFactoryBean.class$("org.springframework.webflow.executor.FlowExecutor")) : class$org$springframework$webflow$executor$FlowExecutor;
    }

    public boolean isSingleton() {
        return true;
    }

    public Object getObject() throws Exception {
        return this.getFlowExecutor();
    }

    public FlowExecutor getFlowExecutor() {
        return this.flowExecutor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

