/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.context.servlet;

import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.springframework.binding.collection.CompositeIterator;
import org.springframework.binding.collection.StringKeyedMapAdapter;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.webflow.core.collection.CollectionUtils;

public class HttpServletRequestParameterMap
extends StringKeyedMapAdapter {
    private HttpServletRequest request;

    public HttpServletRequestParameterMap(HttpServletRequest request) {
        this.request = request;
    }

    protected Object getAttribute(String key) {
        MultipartHttpServletRequest multipartRequest;
        Object data;
        if (this.request instanceof MultipartHttpServletRequest && (data = (multipartRequest = (MultipartHttpServletRequest)this.request).getFileMap().get(key)) != null) {
            return data;
        }
        String[] parameters = this.request.getParameterValues(key);
        if (parameters == null) {
            return null;
        }
        if (parameters.length == 1) {
            return parameters[0];
        }
        return parameters;
    }

    protected void setAttribute(String key, Object value) {
        throw new UnsupportedOperationException("HttpServletRequest parameter maps are immutable");
    }

    protected void removeAttribute(String key) {
        throw new UnsupportedOperationException("HttpServletRequest parameter maps are immutable");
    }

    protected Iterator getAttributeNames() {
        if (this.request instanceof MultipartHttpServletRequest) {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)this.request;
            CompositeIterator iterator = new CompositeIterator();
            iterator.add(multipartRequest.getFileMap().keySet().iterator());
            iterator.add(CollectionUtils.toIterator(this.request.getParameterNames()));
            return iterator;
        }
        return CollectionUtils.toIterator(this.request.getParameterNames());
    }
}

