/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.core;

import org.springframework.binding.expression.ExpressionParser;
import org.springframework.webflow.core.WebFlowOgnlExpressionParser;

public final class DefaultExpressionParserFactory {
    private static ExpressionParser INSTANCE;

    private DefaultExpressionParserFactory() {
    }

    public static synchronized ExpressionParser getExpressionParser() {
        if (INSTANCE == null) {
            INSTANCE = DefaultExpressionParserFactory.createDefaultExpressionParser();
        }
        return INSTANCE;
    }

    private static ExpressionParser createDefaultExpressionParser() {
        try {
            Class.forName("ognl.Ognl");
            return new WebFlowOgnlExpressionParser();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to load the default expression parser: OGNL could not be found in the classpath.  Please add OGNL 2.x to your classpath or set the default ExpressionParser instance to something that is in the classpath.  Details: " + e.getMessage());
        }
        catch (NoClassDefFoundError e) {
            throw new IllegalStateException("Unable to construct the default expression parser: ognl.Ognl could not be instantiated.  Please add OGNL 2.x to your classpath or set the default ExpressionParser instance to something that is in the classpath.  Details: " + e);
        }
    }
}

