/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.factory;

import org.springframework.core.style.StylerUtils;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.execution.factory.FlowExecutionListenerCriteria;

public class FlowExecutionListenerCriteriaFactory {
    public FlowExecutionListenerCriteria allFlows() {
        return new WildcardFlowExecutionListenerCriteria();
    }

    public FlowExecutionListenerCriteria flow(String flowId) {
        return new FlowIdFlowExecutionListenerCriteria(flowId);
    }

    public FlowExecutionListenerCriteria flows(String[] flowIds) {
        return new FlowIdFlowExecutionListenerCriteria(flowIds);
    }

    private static class FlowIdFlowExecutionListenerCriteria
    implements FlowExecutionListenerCriteria {
        private String[] flowIds;

        public FlowIdFlowExecutionListenerCriteria(String flowId) {
            Assert.notNull((Object)flowId, (String)"The flow id is required");
            this.flowIds = new String[]{flowId};
        }

        public FlowIdFlowExecutionListenerCriteria(String[] flowIds) {
            Assert.notEmpty((Object[])flowIds, (String)"The flow id array is required");
            this.flowIds = flowIds;
        }

        public boolean appliesTo(FlowDefinition definition) {
            for (int i = 0; i < this.flowIds.length; ++i) {
                if (!this.flowIds[i].equals(definition.getId())) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("flowIds", (Object)StylerUtils.style((Object)this.flowIds)).toString();
        }
    }

    private static class WildcardFlowExecutionListenerCriteria
    implements FlowExecutionListenerCriteria {
        private WildcardFlowExecutionListenerCriteria() {
        }

        public boolean appliesTo(FlowDefinition definition) {
            return true;
        }

        public String toString() {
            return "*";
        }
    }
}

