/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.config;

import java.io.Serializable;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.config.RepositoryType;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;

public class FlowSystemDefaults
implements Serializable {
    private boolean alwaysRedirectOnPause = true;
    private RepositoryType repositoryType = RepositoryType.CONTINUATION;

    public void setAlwaysRedirectOnPause(boolean alwaysRedirectOnPause) {
        this.alwaysRedirectOnPause = alwaysRedirectOnPause;
    }

    public void setRepositoryType(RepositoryType repositoryType) {
        this.repositoryType = repositoryType;
    }

    public MutableAttributeMap applyExecutionAttributes(MutableAttributeMap executionAttributes) {
        if (executionAttributes == null) {
            executionAttributes = new LocalAttributeMap(1, 1);
        }
        if (!executionAttributes.contains("alwaysRedirectOnPause")) {
            executionAttributes.put("alwaysRedirectOnPause", new Boolean(this.alwaysRedirectOnPause));
        }
        return executionAttributes;
    }

    public RepositoryType applyIfNecessary(RepositoryType selectedType) {
        if (selectedType == null) {
            return this.repositoryType;
        }
        return selectedType;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("alwaysRedirectOnPause", this.alwaysRedirectOnPause).append("repositoryType", (Object)this.repositoryType).toString();
    }
}

