/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.conversation.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.conversation.Conversation;
import org.springframework.webflow.conversation.ConversationException;
import org.springframework.webflow.conversation.ConversationId;
import org.springframework.webflow.conversation.ConversationManager;
import org.springframework.webflow.conversation.ConversationParameters;
import org.springframework.webflow.conversation.impl.ConversationContainer;
import org.springframework.webflow.conversation.impl.SimpleConversationId;
import org.springframework.webflow.core.collection.SharedAttributeMap;
import org.springframework.webflow.util.RandomGuid;
import org.springframework.webflow.util.RandomGuidUidGenerator;
import org.springframework.webflow.util.UidGenerator;

public class SessionBindingConversationManager
implements ConversationManager {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$webflow$conversation$impl$SessionBindingConversationManager == null ? (class$org$springframework$webflow$conversation$impl$SessionBindingConversationManager = SessionBindingConversationManager.class$("org.springframework.webflow.conversation.impl.SessionBindingConversationManager")) : class$org$springframework$webflow$conversation$impl$SessionBindingConversationManager));
    private final String sessionKey = "webflow.conversation.container." + new RandomGuid().toString();
    private UidGenerator conversationIdGenerator = new RandomGuidUidGenerator();
    private int maxConversations = 5;
    static /* synthetic */ Class class$org$springframework$webflow$conversation$impl$SessionBindingConversationManager;

    public UidGenerator getConversationIdGenerator() {
        return this.conversationIdGenerator;
    }

    public void setConversationIdGenerator(UidGenerator uidGenerator) {
        this.conversationIdGenerator = uidGenerator;
    }

    public int getMaxConversations() {
        return this.maxConversations;
    }

    public void setMaxConversations(int maxConversations) {
        this.maxConversations = maxConversations;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public Conversation beginConversation(ConversationParameters conversationParameters) throws ConversationException {
        SimpleConversationId conversationId = new SimpleConversationId(this.conversationIdGenerator.generateUid());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Beginning conversation " + conversationParameters + "; unique conversation id = " + conversationId));
        }
        return this.getConversationContainer().createAndAddConversation(conversationId, conversationParameters);
    }

    public Conversation getConversation(ConversationId id) throws ConversationException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Getting conversation " + id));
        }
        return this.getConversationContainer().getConversation(id);
    }

    public ConversationId parseConversationId(String encodedId) throws ConversationException {
        return new SimpleConversationId(this.conversationIdGenerator.parseUid(encodedId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConversationContainer getConversationContainer() {
        SharedAttributeMap sessionMap = ExternalContextHolder.getExternalContext().getSessionMap();
        Object object = sessionMap.getMutex();
        synchronized (object) {
            ConversationContainer container = (ConversationContainer)sessionMap.get(this.sessionKey);
            if (container == null) {
                container = new ConversationContainer(this.maxConversations, this.sessionKey);
                sessionMap.put(this.sessionKey, container);
            }
            return container;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

