/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.support;

import java.io.Serializable;
import org.springframework.binding.expression.Expression;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.engine.ViewSelector;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ViewSelection;
import org.springframework.webflow.execution.support.ExternalRedirect;

public class ExternalRedirectSelector
implements ViewSelector,
Serializable {
    private Expression urlExpression;

    public ExternalRedirectSelector(Expression urlExpression) {
        this.urlExpression = urlExpression;
    }

    public Expression getUrlExpression() {
        return this.urlExpression;
    }

    public boolean isEntrySelectionRenderable(RequestContext context) {
        return true;
    }

    public ViewSelection makeEntrySelection(RequestContext context) {
        String url = (String)this.urlExpression.evaluate((Object)context, null);
        return new ExternalRedirect(url);
    }

    public ViewSelection makeRefreshSelection(RequestContext context) {
        return this.makeEntrySelection(context);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("urlExpression", (Object)this.urlExpression).toString();
    }
}

