/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.test;

import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.execution.FlowExecutionContext;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.test.MockFlowSession;

public class MockFlowExecutionContext
implements FlowExecutionContext {
    private FlowDefinition flow;
    private FlowSession activeSession;
    private MutableAttributeMap conversationScope = new LocalAttributeMap();
    private MutableAttributeMap attributes = new LocalAttributeMap();

    public MockFlowExecutionContext() {
        this.activeSession = new MockFlowSession();
        this.flow = this.activeSession.getDefinition();
    }

    public MockFlowExecutionContext(Flow rootFlow) {
        this.flow = rootFlow;
        this.activeSession = new MockFlowSession(rootFlow);
    }

    public String getCaption() {
        return "Mock flow execution context";
    }

    public FlowDefinition getDefinition() {
        return this.flow;
    }

    public boolean isActive() {
        return this.activeSession != null;
    }

    public FlowSession getActiveSession() throws IllegalStateException {
        if (this.activeSession == null) {
            throw new IllegalStateException("No flow session is active");
        }
        return this.activeSession;
    }

    public MutableAttributeMap getConversationScope() {
        return this.conversationScope;
    }

    public AttributeMap getAttributes() {
        return this.attributes;
    }

    public void setFlow(Flow rootFlow) {
        this.flow = rootFlow;
    }

    public void setActiveSession(FlowSession activeSession) {
        this.activeSession = activeSession;
    }

    public void setConversationScope(MutableAttributeMap scope) {
        this.conversationScope = scope;
    }

    public MockFlowSession getMockActiveSession() {
        return (MockFlowSession)this.activeSession;
    }

    public MutableAttributeMap getAttributeMap() {
        return this.attributes;
    }

    public void putAttribute(String attributeName, Object attributeValue) {
        this.attributes.put(attributeName, attributeValue);
    }
}

