/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRange;
import org.springframework.http.MediaType;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.server.DefaultServerRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ServerRequest {
    @Nullable
    public HttpMethod method();

    public URI uri();

    default public String path() {
        return this.uri().getRawPath();
    }

    public Headers headers();

    public <T> T body(BodyExtractor<T, ? super ServerHttpRequest> var1);

    public <T> T body(BodyExtractor<T, ? super ServerHttpRequest> var1, Map<String, Object> var2);

    public <T> Mono<T> bodyToMono(Class<? extends T> var1);

    public <T> Flux<T> bodyToFlux(Class<? extends T> var1);

    public <T> Optional<T> attribute(String var1);

    public Map<String, Object> attributes();

    default public Optional<String> queryParam(String name) {
        List<String> queryParams = this.queryParams(name);
        if (queryParams.isEmpty()) {
            return Optional.empty();
        }
        String value = queryParams.get(0);
        if (value == null) {
            value = "";
        }
        return Optional.of(value);
    }

    public List<String> queryParams(String var1);

    default public String pathVariable(String name) {
        Map<String, String> pathVariables = this.pathVariables();
        if (pathVariables.containsKey(name)) {
            return this.pathVariables().get(name);
        }
        throw new IllegalArgumentException("No path variable with name \"" + name + "\" available");
    }

    public Map<String, String> pathVariables();

    public Mono<WebSession> session();

    public Mono<? extends Principal> principal();

    public static ServerRequest create(ServerWebExchange exchange, List<HttpMessageReader<?>> messageReaders) {
        return new DefaultServerRequest(exchange, messageReaders);
    }

    public static interface Headers {
        public List<MediaType> accept();

        public List<Charset> acceptCharset();

        public List<Locale.LanguageRange> acceptLanguage();

        public OptionalLong contentLength();

        public Optional<MediaType> contentType();

        @Nullable
        public InetSocketAddress host();

        public List<HttpRange> range();

        public List<String> header(String var1);

        public HttpHeaders asHttpHeaders();
    }
}

