/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import java.util.ArrayList;
import java.util.Map;
import java.util.SortedSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.web.reactive.handler.PathMatchResult;
import org.springframework.web.reactive.handler.PathPatternRegistry;
import org.springframework.web.reactive.handler.SimpleUrlHandlerMapping;
import org.springframework.web.reactive.resource.DefaultResourceResolverChain;
import org.springframework.web.reactive.resource.ResourceWebHandler;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ResourceUrlProvider
implements ApplicationListener<ContextRefreshedEvent> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private PathPatternRegistry<ResourceWebHandler> patternRegistry = new PathPatternRegistry();
    private boolean autodetect = true;

    public void setPathPatternParser(PathPatternParser patternParser) {
        this.patternRegistry = new PathPatternRegistry(patternParser);
    }

    public void setHandlerMap(@Nullable Map<String, ResourceWebHandler> handlerMap) {
        if (handlerMap != null) {
            this.patternRegistry.clear();
            handlerMap.forEach(this.patternRegistry::register);
            this.autodetect = false;
        }
    }

    public Map<PathPattern, ResourceWebHandler> getHandlerMap() {
        return this.patternRegistry.getPatternsMap();
    }

    public boolean isAutodetect() {
        return this.autodetect;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.isAutodetect()) {
            this.patternRegistry.clear();
            this.detectResourceHandlers(event.getApplicationContext());
            if (!this.patternRegistry.getPatternsMap().isEmpty()) {
                this.autodetect = false;
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"No resource handling mappings found");
            }
        }
    }

    protected void detectResourceHandlers(ApplicationContext appContext) {
        this.logger.debug((Object)"Looking for resource handler mappings");
        Map map = appContext.getBeansOfType(SimpleUrlHandlerMapping.class);
        ArrayList handlerMappings = new ArrayList(map.values());
        AnnotationAwareOrderComparator.sort(handlerMappings);
        for (SimpleUrlHandlerMapping hm : handlerMappings) {
            for (PathPattern pattern : hm.getHandlerMap().keySet()) {
                Object handler = hm.getHandlerMap().get(pattern);
                if (!(handler instanceof ResourceWebHandler)) continue;
                ResourceWebHandler resourceHandler = (ResourceWebHandler)handler;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Found resource handler mapping: URL pattern=\"" + pattern + "\", locations=" + resourceHandler.getLocations() + ", resolvers=" + resourceHandler.getResourceResolvers()));
                }
                this.patternRegistry.register(pattern.getPatternString(), resourceHandler);
            }
        }
    }

    public final Mono<String> getForRequestUrl(ServerWebExchange exchange, String requestUrl) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Getting resource URL for request URL \"" + requestUrl + "\""));
        }
        int prefixIndex = this.getLookupPathIndex(exchange);
        int suffixIndex = this.getEndPathIndex(requestUrl);
        String prefix = requestUrl.substring(0, prefixIndex);
        String suffix = requestUrl.substring(suffixIndex);
        String lookupPath = requestUrl.substring(prefixIndex, suffixIndex);
        return this.getForLookupPath(lookupPath).map(resolvedPath -> prefix + resolvedPath + suffix);
    }

    private int getLookupPathIndex(ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        String requestPath = request.getURI().getPath();
        String lookupPath = exchange.getRequest().getPath().pathWithinApplication().value();
        return requestPath.indexOf(lookupPath);
    }

    private int getEndPathIndex(String lookupPath) {
        int hashIndex;
        int suffixIndex = lookupPath.length();
        int queryIndex = lookupPath.indexOf("?");
        if (queryIndex > 0) {
            suffixIndex = queryIndex;
        }
        if ((hashIndex = lookupPath.indexOf("#")) > 0) {
            suffixIndex = Math.min(suffixIndex, hashIndex);
        }
        return suffixIndex;
    }

    public final Mono<String> getForLookupPath(String lookupPath) {
        SortedSet<PathMatchResult<ResourceWebHandler>> matchResults;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Getting resource URL for lookup path \"" + lookupPath + "\""));
        }
        if ((matchResults = this.patternRegistry.findMatches(lookupPath)).isEmpty()) {
            return Mono.empty();
        }
        return Flux.fromIterable(matchResults).concatMap(result -> {
            String pathWithinMapping = result.getPattern().extractPathWithinPattern(lookupPath);
            String pathMapping = lookupPath.substring(0, lookupPath.indexOf(pathWithinMapping));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Invoking ResourceResolverChain for URL pattern \"" + result.getPattern() + "\""));
            }
            ResourceWebHandler handler = (ResourceWebHandler)result.getHandler();
            DefaultResourceResolverChain chain = new DefaultResourceResolverChain(handler.getResourceResolvers());
            return chain.resolveUrlPath(pathWithinMapping, handler.getLocations()).map(resolvedPath -> {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Resolved public resource URL path \"" + resolvedPath + "\""));
                }
                return pathMapping + resolvedPath;
            });
        }).next();
    }
}

