/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.view.script;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.reactivestreams.Publisher;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.scripting.support.StandardScriptEvalException;
import org.springframework.scripting.support.StandardScriptUtils;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.result.view.AbstractUrlBasedView;
import org.springframework.web.reactive.result.view.script.RenderingContext;
import org.springframework.web.reactive.result.view.script.ScriptTemplateConfig;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ScriptTemplateView
extends AbstractUrlBasedView {
    private static final String DEFAULT_RESOURCE_LOADER_PATH = "classpath:";
    private ScriptEngine engine;
    private String engineName;
    private Locale locale;
    private Boolean sharedEngine;
    private String[] scripts;
    private String renderObject;
    private String renderFunction;
    private String[] resourceLoaderPaths;
    private ResourceLoader resourceLoader;
    private volatile ScriptEngineManager scriptEngineManager;

    public ScriptTemplateView() {
    }

    public ScriptTemplateView(String url) {
        super(url);
    }

    public void setEngine(ScriptEngine engine) {
        Assert.isInstanceOf(Invocable.class, (Object)engine, (String)"ScriptEngine must implement Invocable");
        this.engine = engine;
    }

    public void setEngineName(String engineName) {
        this.engineName = engineName;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setSharedEngine(Boolean sharedEngine) {
        this.sharedEngine = sharedEngine;
    }

    public void setScripts(String ... scripts) {
        this.scripts = scripts;
    }

    public void setRenderObject(String renderObject) {
        this.renderObject = renderObject;
    }

    public void setRenderFunction(String functionName) {
        this.renderFunction = functionName;
    }

    public void setResourceLoaderPath(String resourceLoaderPath) {
        String[] paths = StringUtils.commaDelimitedListToStringArray((String)resourceLoaderPath);
        this.resourceLoaderPaths = new String[paths.length + 1];
        this.resourceLoaderPaths[0] = "";
        for (int i = 0; i < paths.length; ++i) {
            String path2 = paths[i];
            if (!path2.endsWith("/") && !path2.endsWith(":")) {
                path2 = path2 + "/";
            }
            this.resourceLoaderPaths[i + 1] = path2;
        }
    }

    @Override
    public void setApplicationContext(ApplicationContext context) {
        super.setApplicationContext(context);
        ScriptTemplateConfig viewConfig = this.autodetectViewConfig();
        if (this.engine == null && viewConfig.getEngine() != null) {
            this.setEngine(viewConfig.getEngine());
        }
        if (this.engineName == null && viewConfig.getEngineName() != null) {
            this.engineName = viewConfig.getEngineName();
        }
        if (this.scripts == null && viewConfig.getScripts() != null) {
            this.scripts = viewConfig.getScripts();
        }
        if (this.renderObject == null && viewConfig.getRenderObject() != null) {
            this.renderObject = viewConfig.getRenderObject();
        }
        if (this.renderFunction == null && viewConfig.getRenderFunction() != null) {
            this.renderFunction = viewConfig.getRenderFunction();
        }
        if (viewConfig.getCharset() != null) {
            this.setDefaultCharset(viewConfig.getCharset());
        }
        if (this.resourceLoaderPaths == null) {
            String resourceLoaderPath = viewConfig.getResourceLoaderPath();
            this.setResourceLoaderPath(resourceLoaderPath == null ? DEFAULT_RESOURCE_LOADER_PATH : resourceLoaderPath);
        }
        if (this.resourceLoader == null) {
            this.resourceLoader = this.getApplicationContext();
        }
        if (this.sharedEngine == null && viewConfig.isSharedEngine() != null) {
            this.sharedEngine = viewConfig.isSharedEngine();
        }
        Assert.isTrue((this.engine == null || this.engineName == null ? 1 : 0) != 0, (String)"You should define either 'engine' or 'engineName', not both.");
        Assert.isTrue((this.engine != null || this.engineName != null ? 1 : 0) != 0, (String)"No script engine found, please specify either 'engine' or 'engineName'.");
        if (Boolean.FALSE.equals(this.sharedEngine)) {
            Assert.isTrue((this.engineName != null ? 1 : 0) != 0, (String)"When 'sharedEngine' is set to false, you should specify the script engine using the 'engineName' property, not the 'engine' one.");
        } else if (this.engine != null) {
            this.loadScripts(this.engine);
        } else {
            this.setEngine(this.createEngineFromName());
        }
        Assert.isTrue((this.renderFunction != null ? 1 : 0) != 0, (String)"The 'renderFunction' property must be defined.");
    }

    protected ScriptEngine getEngine() {
        return Boolean.FALSE.equals(this.sharedEngine) ? this.createEngineFromName() : this.engine;
    }

    protected ScriptEngine createEngineFromName() {
        if (this.scriptEngineManager == null) {
            this.scriptEngineManager = new ScriptEngineManager(this.obtainApplicationContext().getClassLoader());
        }
        ScriptEngine engine = StandardScriptUtils.retrieveEngineByName((ScriptEngineManager)this.scriptEngineManager, (String)this.engineName);
        this.loadScripts(engine);
        return engine;
    }

    protected void loadScripts(ScriptEngine engine) {
        if (!ObjectUtils.isEmpty((Object[])this.scripts)) {
            for (String script : this.scripts) {
                Resource resource = this.getResource(script);
                if (resource == null) {
                    throw new IllegalStateException("Script resource [" + script + "] not found");
                }
                try {
                    engine.eval(new InputStreamReader(resource.getInputStream()));
                }
                catch (Throwable ex) {
                    throw new IllegalStateException("Failed to evaluate script [" + script + "]", ex);
                }
            }
        }
    }

    @Nullable
    protected Resource getResource(String location) {
        for (String path2 : this.resourceLoaderPaths) {
            Resource resource = this.resourceLoader.getResource(path2 + location);
            if (!resource.exists()) continue;
            return resource;
        }
        return null;
    }

    protected ScriptTemplateConfig autodetectViewConfig() throws BeansException {
        try {
            return (ScriptTemplateConfig)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.obtainApplicationContext(), ScriptTemplateConfig.class, (boolean)true, (boolean)false);
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw new ApplicationContextException("Expected a single ScriptTemplateConfig bean in the current web application context or the parent root context: ScriptTemplateConfigurer is the usual implementation. This bean may have any name.", (Throwable)ex);
        }
    }

    @Override
    public boolean checkResourceExists(Locale locale) throws Exception {
        String url = this.getUrl();
        Assert.state((url != null ? 1 : 0) != 0, (String)"'url' not set");
        return this.getResource(url) != null;
    }

    @Override
    protected Mono<Void> renderInternal(Map<String, Object> model, @Nullable MediaType contentType2, ServerWebExchange exchange) {
        return Mono.defer(() -> {
            ServerHttpResponse response = exchange.getResponse();
            try {
                Object html;
                ScriptEngine engine = this.getEngine();
                Invocable invocable = (Invocable)((Object)engine);
                String url = this.getUrl();
                Assert.state((url != null ? 1 : 0) != 0, (String)"'url' not set");
                String template = this.getTemplate(url);
                Function<String, String> templateLoader = path2 -> {
                    try {
                        return this.getTemplate((String)path2);
                    }
                    catch (IOException ex) {
                        throw new IllegalStateException(ex);
                    }
                };
                RenderingContext context = new RenderingContext(this.obtainApplicationContext(), this.locale, templateLoader, url);
                if (this.renderObject != null) {
                    Object thiz = engine.eval(this.renderObject);
                    html = invocable.invokeMethod(thiz, this.renderFunction, template, model, context);
                } else {
                    html = invocable.invokeFunction(this.renderFunction, template, model, context);
                }
                byte[] bytes = String.valueOf(html).getBytes(StandardCharsets.UTF_8);
                DataBuffer buffer = response.bufferFactory().allocateBuffer(bytes.length).write(bytes);
                return response.writeWith((Publisher)Mono.just((Object)buffer));
            }
            catch (ScriptException ex) {
                throw new IllegalStateException("Failed to render script template", (Throwable)new StandardScriptEvalException(ex));
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to render script template", ex);
            }
        });
    }

    protected String getTemplate(String path2) throws IOException {
        Resource resource = this.getResource(path2);
        if (resource == null) {
            throw new IllegalStateException("Template resource [" + path2 + "] not found");
        }
        InputStreamReader reader = new InputStreamReader(resource.getInputStream(), this.getDefaultCharset());
        return FileCopyUtils.copyToString((Reader)reader);
    }
}

