/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.server.DefaultServerRequest;
import org.springframework.web.reactive.function.server.HandlerFilterFunction;
import org.springframework.web.reactive.function.server.HandlerFunction;
import org.springframework.web.reactive.function.server.HandlerStrategies;
import org.springframework.web.reactive.function.server.PathResourceLookupFunction;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.ResourceHandlerFunction;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.reactive.function.server.ToStringVisitor;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebHandler;
import org.springframework.web.server.adapter.WebHttpHandlerBuilder;
import reactor.core.publisher.Mono;

public abstract class RouterFunctions {
    private static final Log logger = LogFactory.getLog(RouterFunctions.class);
    public static final String REQUEST_ATTRIBUTE = RouterFunctions.class.getName() + ".request";
    public static final String URI_TEMPLATE_VARIABLES_ATTRIBUTE = RouterFunctions.class.getName() + ".uriTemplateVariables";
    private static final HandlerFunction<ServerResponse> NOT_FOUND_HANDLER = request -> ServerResponse.notFound().build();

    public static <T extends ServerResponse> RouterFunction<T> route(RequestPredicate predicate, HandlerFunction<T> handlerFunction) {
        Assert.notNull((Object)predicate, (String)"'predicate' must not be null");
        Assert.notNull(handlerFunction, (String)"'handlerFunction' must not be null");
        return new DefaultRouterFunction<T>(predicate, handlerFunction);
    }

    public static <T extends ServerResponse> RouterFunction<T> nest(RequestPredicate predicate, RouterFunction<T> routerFunction) {
        Assert.notNull((Object)predicate, (String)"'predicate' must not be null");
        Assert.notNull(routerFunction, (String)"'routerFunction' must not be null");
        return new DefaultNestedRouterFunction<T>(predicate, routerFunction);
    }

    public static RouterFunction<ServerResponse> resources(String pattern, Resource location) {
        Assert.hasLength((String)pattern, (String)"'pattern' must not be empty");
        Assert.notNull((Object)location, (String)"'location' must not be null");
        return RouterFunctions.resources(new PathResourceLookupFunction(pattern, location));
    }

    public static RouterFunction<ServerResponse> resources(Function<ServerRequest, Mono<Resource>> lookupFunction) {
        Assert.notNull(lookupFunction, (String)"'lookupFunction' must not be null");
        return new ResourcesRouterFunction(lookupFunction);
    }

    public static HttpHandler toHttpHandler(RouterFunction<?> routerFunction) {
        return RouterFunctions.toHttpHandler(routerFunction, HandlerStrategies.withDefaults());
    }

    public static HttpHandler toHttpHandler(RouterFunction<?> routerFunction, HandlerStrategies strategies) {
        Assert.notNull(routerFunction, (String)"RouterFunction must not be null");
        Assert.notNull((Object)strategies, (String)"HandlerStrategies must not be null");
        WebHandler webHandler = RouterFunctions.toWebHandler(routerFunction, strategies);
        return WebHttpHandlerBuilder.webHandler((WebHandler)webHandler).filters(filters -> filters.addAll(strategies.webFilters())).exceptionHandlers(handlers -> handlers.addAll(strategies.exceptionHandlers())).localeContextResolver(strategies.localeContextResolver()).build();
    }

    public static WebHandler toWebHandler(RouterFunction<?> routerFunction) {
        return RouterFunctions.toWebHandler(routerFunction, HandlerStrategies.withDefaults());
    }

    public static WebHandler toWebHandler(RouterFunction<?> routerFunction, HandlerStrategies strategies) {
        Assert.notNull(routerFunction, (String)"RouterFunction must not be null");
        Assert.notNull((Object)strategies, (String)"HandlerStrategies must not be null");
        return exchange -> {
            DefaultServerRequest request = new DefaultServerRequest(exchange, strategies.messageReaders());
            RouterFunctions.addAttributes(exchange, request);
            return routerFunction.route(request).defaultIfEmpty(RouterFunctions.notFound()).flatMap(handlerFunction -> RouterFunctions.wrapException(() -> handlerFunction.handle(request))).flatMap(response -> RouterFunctions.wrapException(() -> response.writeTo(exchange, new HandlerStrategiesResponseContext(strategies))));
        };
    }

    private static <T> Mono<T> wrapException(Supplier<Mono<T>> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable t) {
            return Mono.error((Throwable)t);
        }
    }

    private static void addAttributes(ServerWebExchange exchange, ServerRequest request) {
        Map attributes = exchange.getAttributes();
        attributes.put(REQUEST_ATTRIBUTE, request);
    }

    private static <T extends ServerResponse> HandlerFunction<T> notFound() {
        return NOT_FOUND_HANDLER;
    }

    static <T extends ServerResponse> HandlerFunction<T> cast(HandlerFunction<?> handlerFunction) {
        return handlerFunction;
    }

    private static class HandlerStrategiesResponseContext
    implements ServerResponse.Context {
        private final HandlerStrategies strategies;

        public HandlerStrategiesResponseContext(HandlerStrategies strategies) {
            this.strategies = strategies;
        }

        @Override
        public List<HttpMessageWriter<?>> messageWriters() {
            return this.strategies.messageWriters();
        }

        @Override
        public List<ViewResolver> viewResolvers() {
            return this.strategies.viewResolvers();
        }
    }

    private static class ResourcesRouterFunction
    extends AbstractRouterFunction<ServerResponse> {
        private final Function<ServerRequest, Mono<Resource>> lookupFunction;

        public ResourcesRouterFunction(Function<ServerRequest, Mono<Resource>> lookupFunction) {
            this.lookupFunction = lookupFunction;
        }

        @Override
        public Mono<HandlerFunction<ServerResponse>> route(ServerRequest request) {
            return this.lookupFunction.apply(request).map(ResourceHandlerFunction::new);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.resources(this.lookupFunction);
        }
    }

    private static final class DefaultNestedRouterFunction<T extends ServerResponse>
    extends AbstractRouterFunction<T> {
        private final RequestPredicate predicate;
        private final RouterFunction<T> routerFunction;

        public DefaultNestedRouterFunction(RequestPredicate predicate, RouterFunction<T> routerFunction) {
            this.predicate = predicate;
            this.routerFunction = routerFunction;
        }

        @Override
        public Mono<HandlerFunction<T>> route(ServerRequest serverRequest) {
            return this.predicate.nest(serverRequest).map(nestedRequest -> {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Nested predicate \"%s\" matches against \"%s\"", this.predicate, serverRequest));
                }
                return this.routerFunction.route((ServerRequest)nestedRequest);
            }).orElseGet(Mono::empty);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.startNested(this.predicate);
            this.routerFunction.accept(visitor);
            visitor.endNested(this.predicate);
        }
    }

    private static final class DefaultRouterFunction<T extends ServerResponse>
    extends AbstractRouterFunction<T> {
        private final RequestPredicate predicate;
        private final HandlerFunction<T> handlerFunction;

        public DefaultRouterFunction(RequestPredicate predicate, HandlerFunction<T> handlerFunction) {
            this.predicate = predicate;
            this.handlerFunction = handlerFunction;
        }

        @Override
        public Mono<HandlerFunction<T>> route(ServerRequest request) {
            if (this.predicate.test(request)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Predicate \"%s\" matches against \"%s\"", this.predicate, request));
                }
                return Mono.just(this.handlerFunction);
            }
            return Mono.empty();
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.route(this.predicate, this.handlerFunction);
        }
    }

    static final class FilteredRouterFunction<T extends ServerResponse, S extends ServerResponse>
    implements RouterFunction<S> {
        private final RouterFunction<T> routerFunction;
        private final HandlerFilterFunction<T, S> filterFunction;

        public FilteredRouterFunction(RouterFunction<T> routerFunction, HandlerFilterFunction<T, S> filterFunction) {
            this.routerFunction = routerFunction;
            this.filterFunction = filterFunction;
        }

        @Override
        public Mono<HandlerFunction<S>> route(ServerRequest request) {
            return this.routerFunction.route(request).map(this.filterFunction::apply);
        }

        @Override
        public void accept(Visitor visitor) {
            this.routerFunction.accept(visitor);
        }
    }

    static final class DifferentComposedRouterFunction
    extends AbstractRouterFunction<ServerResponse> {
        private final RouterFunction<?> first;
        private final RouterFunction<?> second;

        public DifferentComposedRouterFunction(RouterFunction<?> first, RouterFunction<?> second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public Mono<HandlerFunction<ServerResponse>> route(ServerRequest request) {
            return this.first.route(request).map(RouterFunctions::cast).switchIfEmpty(Mono.defer(() -> this.second.route(request).map(RouterFunctions::cast)));
        }

        @Override
        public void accept(Visitor visitor) {
            this.first.accept(visitor);
            this.second.accept(visitor);
        }
    }

    static final class SameComposedRouterFunction<T extends ServerResponse>
    extends AbstractRouterFunction<T> {
        private final RouterFunction<T> first;
        private final RouterFunction<T> second;

        public SameComposedRouterFunction(RouterFunction<T> first, RouterFunction<T> second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public Mono<HandlerFunction<T>> route(ServerRequest request) {
            return this.first.route(request).switchIfEmpty(Mono.defer(() -> this.second.route(request)));
        }

        @Override
        public void accept(Visitor visitor) {
            this.first.accept(visitor);
            this.second.accept(visitor);
        }
    }

    private static abstract class AbstractRouterFunction<T extends ServerResponse>
    implements RouterFunction<T> {
        private AbstractRouterFunction() {
        }

        public String toString() {
            ToStringVisitor visitor = new ToStringVisitor();
            this.accept(visitor);
            return visitor.toString();
        }
    }

    public static interface Visitor {
        public void startNested(RequestPredicate var1);

        public void endNested(RequestPredicate var1);

        public void route(RequestPredicate var1, HandlerFunction<?> var2);

        public void resources(Function<ServerRequest, Mono<Resource>> var1);

        public void unknown(RouterFunction<?> var1);
    }
}

