/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.core.Ordered;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.server.ServerWebExchange;

public abstract class HandlerResultHandlerSupport
implements Ordered {
    private static final MediaType MEDIA_TYPE_APPLICATION_ALL = new MediaType("application");
    private final RequestedContentTypeResolver contentTypeResolver;
    private final ReactiveAdapterRegistry adapterRegistry;
    private int order = Integer.MAX_VALUE;

    protected HandlerResultHandlerSupport(RequestedContentTypeResolver contentTypeResolver, ReactiveAdapterRegistry adapterRegistry) {
        Assert.notNull((Object)contentTypeResolver, (String)"RequestedContentTypeResolver is required");
        Assert.notNull((Object)adapterRegistry, (String)"ReactiveAdapterRegistry is required");
        this.contentTypeResolver = contentTypeResolver;
        this.adapterRegistry = adapterRegistry;
    }

    public ReactiveAdapterRegistry getAdapterRegistry() {
        return this.adapterRegistry;
    }

    public RequestedContentTypeResolver getContentTypeResolver() {
        return this.contentTypeResolver;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    @Nullable
    protected ReactiveAdapter getAdapter(HandlerResult result) {
        Class returnType = result.getReturnType().getRawClass();
        return this.getAdapterRegistry().getAdapter(returnType, result.getReturnValue());
    }

    @Nullable
    protected MediaType selectMediaType(ServerWebExchange exchange, Supplier<List<MediaType>> producibleTypesSupplier) {
        List<MediaType> acceptableTypes = this.getAcceptableTypes(exchange);
        List<MediaType> producibleTypes = this.getProducibleTypes(exchange, producibleTypesSupplier);
        LinkedHashSet<MediaType> compatibleMediaTypes = new LinkedHashSet<MediaType>();
        for (MediaType acceptable : acceptableTypes) {
            for (MediaType producible : producibleTypes) {
                if (!acceptable.isCompatibleWith(producible)) continue;
                compatibleMediaTypes.add(this.selectMoreSpecificMediaType(acceptable, producible));
            }
        }
        ArrayList result = new ArrayList(compatibleMediaTypes);
        MediaType.sortBySpecificityAndQuality(result);
        for (MediaType mediaType : result) {
            if (mediaType.isConcrete()) {
                return mediaType;
            }
            if (!mediaType.equals((Object)MediaType.ALL) && !mediaType.equals((Object)MEDIA_TYPE_APPLICATION_ALL)) continue;
            return MediaType.APPLICATION_OCTET_STREAM;
        }
        return null;
    }

    private List<MediaType> getAcceptableTypes(ServerWebExchange exchange) {
        List<MediaType> mediaTypes = this.getContentTypeResolver().resolveMediaTypes(exchange);
        return mediaTypes.isEmpty() ? Collections.singletonList(MediaType.ALL) : mediaTypes;
    }

    private List<MediaType> getProducibleTypes(ServerWebExchange exchange, Supplier<List<MediaType>> producibleTypesSupplier) {
        Set mediaTypes = (Set)exchange.getAttribute(HandlerMapping.PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE);
        return mediaTypes != null ? new ArrayList(mediaTypes) : producibleTypesSupplier.get();
    }

    private MediaType selectMoreSpecificMediaType(MediaType acceptable, MediaType producible) {
        Comparator comparator = MediaType.SPECIFICITY_COMPARATOR;
        return comparator.compare(acceptable, producible = producible.copyQualityValue(acceptable)) <= 0 ? acceptable : producible;
    }
}

