/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.adapter;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import java.util.function.IntPredicate;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.api.Callback;
import org.eclipse.jetty.websocket.api.Session;
import org.jspecify.annotations.Nullable;
import org.springframework.core.io.buffer.CloseableDataBuffer;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.util.Assert;
import org.springframework.web.reactive.socket.CloseStatus;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.adapter.JettyWebSocketSession;

public class JettyWebSocketHandlerAdapter
implements Session.Listener {
    private final WebSocketHandler delegateHandler;
    private final Function<Session, JettyWebSocketSession> sessionFactory;
    private @Nullable JettyWebSocketSession delegateSession;

    public JettyWebSocketHandlerAdapter(WebSocketHandler handler, Function<Session, JettyWebSocketSession> sessionFactory) {
        Assert.notNull((Object)handler, (String)"WebSocketHandler is required");
        Assert.notNull(sessionFactory, (String)"'sessionFactory' is required");
        this.delegateHandler = handler;
        this.sessionFactory = sessionFactory;
    }

    public void onWebSocketOpen(Session session) {
        JettyWebSocketSession delegateSession;
        this.delegateSession = delegateSession = this.sessionFactory.apply(session);
        this.delegateHandler.handle(delegateSession).checkpoint(String.valueOf(session.getUpgradeRequest().getRequestURI()) + " [JettyWebSocketHandlerAdapter]").subscribe(unused -> {}, delegateSession::onHandlerError, delegateSession::onHandleComplete);
    }

    public void onWebSocketText(String message) {
        Assert.state((this.delegateSession != null ? 1 : 0) != 0, (String)"No delegate session available");
        byte[] bytes = message.getBytes(StandardCharsets.UTF_8);
        DataBuffer buffer = this.delegateSession.bufferFactory().wrap(bytes);
        WebSocketMessage webSocketMessage = new WebSocketMessage(WebSocketMessage.Type.TEXT, buffer);
        this.delegateSession.handleMessage(webSocketMessage);
    }

    public void onWebSocketBinary(ByteBuffer byteBuffer, Callback callback) {
        Assert.state((this.delegateSession != null ? 1 : 0) != 0, (String)"No delegate session available");
        Object buffer = this.delegateSession.bufferFactory().wrap(byteBuffer);
        buffer = new JettyCallbackDataBuffer((DataBuffer)buffer, callback);
        WebSocketMessage webSocketMessage = new WebSocketMessage(WebSocketMessage.Type.BINARY, (DataBuffer)buffer);
        this.delegateSession.handleMessage(webSocketMessage);
    }

    public void onWebSocketPong(ByteBuffer payload) {
        Assert.state((this.delegateSession != null ? 1 : 0) != 0, (String)"No delegate session available");
        DataBuffer buffer = this.delegateSession.bufferFactory().wrap(BufferUtil.copy((ByteBuffer)payload));
        WebSocketMessage webSocketMessage = new WebSocketMessage(WebSocketMessage.Type.PONG, buffer);
        this.delegateSession.handleMessage(webSocketMessage);
    }

    public void onWebSocketClose(int statusCode, String reason) {
        Assert.state((this.delegateSession != null ? 1 : 0) != 0, (String)"No delegate session available");
        this.delegateSession.handleClose(CloseStatus.create(statusCode, reason));
    }

    public void onWebSocketError(Throwable cause) {
        Assert.state((this.delegateSession != null ? 1 : 0) != 0, (String)"No delegate session available");
        this.delegateSession.handleError(cause);
    }

    private static final class JettyCallbackDataBuffer
    implements CloseableDataBuffer {
        private final DataBuffer delegate;
        private final Callback callback;

        public JettyCallbackDataBuffer(DataBuffer delegate, Callback callback) {
            Assert.notNull((Object)delegate, (String)"'delegate` must not be null");
            Assert.notNull((Object)callback, (String)"Callback must not be null");
            this.delegate = delegate;
            this.callback = callback;
        }

        public void close() {
            this.callback.succeed();
        }

        public DataBufferFactory factory() {
            return this.delegate.factory();
        }

        public int indexOf(IntPredicate predicate, int fromIndex) {
            return this.delegate.indexOf(predicate, fromIndex);
        }

        public int lastIndexOf(IntPredicate predicate, int fromIndex) {
            return this.delegate.lastIndexOf(predicate, fromIndex);
        }

        public int readableByteCount() {
            return this.delegate.readableByteCount();
        }

        public int writableByteCount() {
            return this.delegate.writableByteCount();
        }

        public int capacity() {
            return this.delegate.capacity();
        }

        @Deprecated(since="6.0")
        public DataBuffer capacity(int capacity) {
            this.delegate.capacity(capacity);
            return this;
        }

        public DataBuffer ensureWritable(int capacity) {
            this.delegate.ensureWritable(capacity);
            return this;
        }

        public int readPosition() {
            return this.delegate.readPosition();
        }

        public DataBuffer readPosition(int readPosition) {
            this.delegate.readPosition(readPosition);
            return this;
        }

        public int writePosition() {
            return this.delegate.writePosition();
        }

        public DataBuffer writePosition(int writePosition) {
            this.delegate.writePosition(writePosition);
            return this;
        }

        public byte getByte(int index) {
            return this.delegate.getByte(index);
        }

        public byte read() {
            return this.delegate.read();
        }

        public DataBuffer read(byte[] destination) {
            this.delegate.read(destination);
            return this;
        }

        public DataBuffer read(byte[] destination, int offset, int length) {
            this.delegate.read(destination, offset, length);
            return this;
        }

        public DataBuffer write(byte b) {
            this.delegate.write(b);
            return this;
        }

        public DataBuffer write(byte[] source) {
            this.delegate.write(source);
            return this;
        }

        public DataBuffer write(byte[] source, int offset, int length) {
            this.delegate.write(source, offset, length);
            return this;
        }

        public DataBuffer write(DataBuffer ... buffers) {
            this.delegate.write(buffers);
            return this;
        }

        public DataBuffer write(ByteBuffer ... buffers) {
            this.delegate.write(buffers);
            return this;
        }

        @Deprecated(since="6.0")
        public DataBuffer slice(int index, int length) {
            DataBuffer delegateSlice = this.delegate.slice(index, length);
            return new JettyCallbackDataBuffer(delegateSlice, this.callback);
        }

        public DataBuffer split(int index) {
            DataBuffer delegateSplit = this.delegate.split(index);
            return new JettyCallbackDataBuffer(delegateSplit, this.callback);
        }

        @Deprecated(since="6.0")
        public ByteBuffer asByteBuffer() {
            return this.delegate.asByteBuffer();
        }

        @Deprecated(since="6.0")
        public ByteBuffer asByteBuffer(int index, int length) {
            return this.delegate.asByteBuffer(index, length);
        }

        @Deprecated(since="6.0.5")
        public ByteBuffer toByteBuffer(int index, int length) {
            return this.delegate.toByteBuffer(index, length);
        }

        public void toByteBuffer(int srcPos, ByteBuffer dest, int destPos, int length) {
            this.delegate.toByteBuffer(srcPos, dest, destPos, length);
        }

        public DataBuffer.ByteBufferIterator readableByteBuffers() {
            return this.delegate.readableByteBuffers();
        }

        public DataBuffer.ByteBufferIterator writableByteBuffers() {
            return this.delegate.writableByteBuffers();
        }

        public String toString(int index, int length, Charset charset) {
            return this.delegate.toString(index, length, charset);
        }
    }
}

