/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentRegistrar;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.config.AbstractSpecificationExecutor;
import org.springframework.context.config.SpecificationContext;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.config.MvcDefaultServletHandler;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.mvc.HttpRequestHandlerAdapter;
import org.springframework.web.servlet.resource.DefaultServletHttpRequestHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MvcDefaultServletHandlerExecutor
extends AbstractSpecificationExecutor<MvcDefaultServletHandler> {
    private static final String HANDLER_ADAPTER_BEAN_NAME = "org.springframework.web.servlet.mvc.HttpRequestHandlerAdapter";

    MvcDefaultServletHandlerExecutor() {
    }

    protected void doExecute(MvcDefaultServletHandler spec, SpecificationContext specContext) {
        BeanDefinitionRegistry registry = specContext.getRegistry();
        ComponentRegistrar registrar = specContext.getRegistrar();
        Object source = spec.source();
        if (!registry.containsBeanDefinition(HANDLER_ADAPTER_BEAN_NAME)) {
            RootBeanDefinition handlerAdapterDef = new RootBeanDefinition(HttpRequestHandlerAdapter.class);
            handlerAdapterDef.setSource(source);
            handlerAdapterDef.setRole(2);
            registry.registerBeanDefinition(HANDLER_ADAPTER_BEAN_NAME, (BeanDefinition)handlerAdapterDef);
            registrar.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)handlerAdapterDef, HANDLER_ADAPTER_BEAN_NAME));
        }
        RootBeanDefinition defaultServletHandlerDef = new RootBeanDefinition(DefaultServletHttpRequestHandler.class);
        defaultServletHandlerDef.setSource(source);
        defaultServletHandlerDef.setRole(2);
        if (StringUtils.hasText((String)spec.defaultServletName())) {
            defaultServletHandlerDef.getPropertyValues().add("defaultServletName", (Object)spec.defaultServletName());
        }
        String defaultServletHandlerName = registrar.registerWithGeneratedName((BeanDefinition)defaultServletHandlerDef);
        registry.registerBeanDefinition(defaultServletHandlerName, (BeanDefinition)defaultServletHandlerDef);
        registrar.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)defaultServletHandlerDef, defaultServletHandlerName));
        ManagedMap urlMap = new ManagedMap();
        urlMap.put("/**", defaultServletHandlerName);
        RootBeanDefinition handlerMappingDef = new RootBeanDefinition(SimpleUrlHandlerMapping.class);
        handlerMappingDef.setSource(source);
        handlerMappingDef.setRole(2);
        handlerMappingDef.getPropertyValues().add("urlMap", (Object)urlMap);
        String handlerMappingBeanName = registrar.registerWithGeneratedName((BeanDefinition)handlerMappingDef);
        registry.registerBeanDefinition(handlerMappingBeanName, (BeanDefinition)handlerMappingDef);
        registrar.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)handlerMappingDef, handlerMappingBeanName));
    }
}

