/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config;

import org.springframework.beans.factory.parsing.ProblemCollector;
import org.springframework.context.config.AbstractFeatureSpecification;
import org.springframework.context.config.FeatureSpecificationExecutor;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.config.MvcResourcesExecutor;

public final class MvcResources
extends AbstractFeatureSpecification {
    private static final Class<? extends FeatureSpecificationExecutor> EXECUTOR_TYPE = MvcResourcesExecutor.class;
    private Object[] locations;
    private String mapping;
    private Object cachePeriod;
    private Object order = 0x7FFFFFFE;

    public MvcResources(String mapping, String ... locations) {
        super(EXECUTOR_TYPE);
        this.locations = locations;
        this.mapping = mapping;
    }

    public MvcResources(String mapping, Resource ... resources) {
        super(EXECUTOR_TYPE);
        this.locations = resources;
        this.mapping = mapping;
    }

    public MvcResources cachePeriod(Integer cachePeriod) {
        this.cachePeriod = cachePeriod;
        return this;
    }

    public MvcResources cachePeriod(String cachePeriod) {
        this.cachePeriod = cachePeriod;
        return this;
    }

    public MvcResources order(Integer order) {
        this.order = order;
        return this;
    }

    public MvcResources order(String order) {
        this.order = order;
        return this;
    }

    Object cachePeriod() {
        return this.cachePeriod;
    }

    Object[] locations() {
        return this.locations;
    }

    String mapping() {
        return this.mapping;
    }

    Object order() {
        return this.order;
    }

    protected void doValidate(ProblemCollector problems) {
        if (!StringUtils.hasText((String)this.mapping)) {
            problems.error("Mapping is required");
        }
        if (this.locations == null || this.locations.length == 0) {
            problems.error("At least one location is required");
        }
    }
}

