/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentRegistrar;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.config.AbstractSpecificationExecutor;
import org.springframework.context.config.SpecificationContext;
import org.springframework.web.servlet.config.MvcResources;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.mvc.HttpRequestHandlerAdapter;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MvcResourcesExecutor
extends AbstractSpecificationExecutor<MvcResources> {
    private static final String HANDLER_ADAPTER_BEAN_NAME = "org.springframework.web.servlet.mvc.HttpRequestHandlerAdapter";

    MvcResourcesExecutor() {
    }

    protected void doExecute(MvcResources spec, SpecificationContext specContext) {
        BeanDefinitionRegistry registry = specContext.getRegistry();
        ComponentRegistrar registrar = specContext.getRegistrar();
        Object source = spec.source();
        if (!registry.containsBeanDefinition(HANDLER_ADAPTER_BEAN_NAME)) {
            RootBeanDefinition handlerAdapterDef = new RootBeanDefinition(HttpRequestHandlerAdapter.class);
            handlerAdapterDef.setSource(source);
            handlerAdapterDef.setRole(2);
            registry.registerBeanDefinition(HANDLER_ADAPTER_BEAN_NAME, (BeanDefinition)handlerAdapterDef);
            registrar.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)handlerAdapterDef, HANDLER_ADAPTER_BEAN_NAME));
        }
        RootBeanDefinition resourceHandlerDef = new RootBeanDefinition(ResourceHttpRequestHandler.class);
        resourceHandlerDef.setSource(source);
        resourceHandlerDef.setRole(2);
        resourceHandlerDef.getPropertyValues().add("locations", (Object)spec.locations());
        if (spec.cachePeriod() != null) {
            resourceHandlerDef.getPropertyValues().add("cacheSeconds", spec.cachePeriod());
        }
        String resourceHandlerBeanName = registrar.registerWithGeneratedName((BeanDefinition)resourceHandlerDef);
        registry.registerBeanDefinition(resourceHandlerBeanName, (BeanDefinition)resourceHandlerDef);
        registrar.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)resourceHandlerDef, resourceHandlerBeanName));
        ManagedMap urlMap = new ManagedMap();
        urlMap.put(spec.mapping(), resourceHandlerBeanName);
        RootBeanDefinition handlerMappingDef = new RootBeanDefinition(SimpleUrlHandlerMapping.class);
        handlerMappingDef.setSource(source);
        handlerMappingDef.setRole(2);
        handlerMappingDef.getPropertyValues().add("urlMap", (Object)urlMap);
        if (spec.order() != null) {
            handlerMappingDef.getPropertyValues().add("order", spec.order());
        }
        String beanName = registrar.registerWithGeneratedName((BeanDefinition)handlerMappingDef);
        registry.registerBeanDefinition(beanName, (BeanDefinition)handlerMappingDef);
        registrar.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)handlerMappingDef, beanName));
    }
}

