/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.MappingJacksonValue;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.mvc.method.annotation.AbstractMappingJacksonResponseBodyAdvice;

public abstract class AbstractJsonpResponseBodyAdvice
extends AbstractMappingJacksonResponseBodyAdvice {
    private final String[] jsonpQueryParamNames;

    protected AbstractJsonpResponseBodyAdvice(Collection<String> queryParamNames) {
        Assert.isTrue((!CollectionUtils.isEmpty(queryParamNames) ? 1 : 0) != 0, (String)"At least one query param name is required");
        this.jsonpQueryParamNames = queryParamNames.toArray(new String[queryParamNames.size()]);
    }

    @Override
    protected void beforeBodyWriteInternal(MappingJacksonValue bodyContainer, MediaType contentType, MethodParameter returnType, ServerHttpRequest request, ServerHttpResponse response) {
        HttpServletRequest servletRequest = ((ServletServerHttpRequest)request).getServletRequest();
        for (String name : this.jsonpQueryParamNames) {
            String value = servletRequest.getParameter(name);
            if (value == null) continue;
            MediaType contentTypeToUse = this.getContentType(contentType, request, response);
            response.getHeaders().setContentType(contentTypeToUse);
            bodyContainer.setJsonpFunction(value);
            return;
        }
    }

    protected MediaType getContentType(MediaType contentType, ServerHttpRequest request, ServerHttpResponse response) {
        return new MediaType("application", "javascript");
    }
}

