/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.resource.VersionStrategy;

public abstract class AbstractVersionStrategy
implements VersionStrategy {
    private static final Pattern pattern = Pattern.compile("-(\\S*)\\.");
    protected final Log logger = LogFactory.getLog(this.getClass());

    protected String extractVersionFromFilename(String requestPath) {
        Matcher matcher = pattern.matcher(requestPath);
        if (matcher.find()) {
            String match = matcher.group(1);
            return match.contains("-") ? match.substring(match.lastIndexOf("-") + 1) : match;
        }
        return "";
    }

    protected String deleteVersionFromFilename(String requestPath, String candidateVersion) {
        return StringUtils.delete((String)requestPath, (String)("-" + candidateVersion));
    }

    protected String addVersionToFilename(String baseUrl, String version) {
        String baseFilename = StringUtils.stripFilenameExtension((String)baseUrl);
        String extension = StringUtils.getFilenameExtension((String)baseUrl);
        return baseFilename + "-" + version + "." + extension;
    }

    protected String extractVersionAsPrefix(String requestPath, String prefix) {
        if (requestPath.startsWith(prefix)) {
            return prefix;
        }
        return "";
    }

    protected String deleteVersionAsPrefix(String requestPath, String version) {
        return requestPath.substring(version.length());
    }

    protected String addVersionAsPrefix(String baseUrl, String version) {
        return version + baseUrl;
    }
}

