/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.util.DigestUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.servlet.resource.AbstractVersionStrategy;
import org.springframework.web.servlet.resource.ResourceResolverChain;

public class ContentBasedVersionStrategy
extends AbstractVersionStrategy {
    @Override
    public String extractVersionFromPath(String requestPath) {
        return this.extractVersionFromFilename(requestPath);
    }

    @Override
    public String deleteVersionFromPath(String requestPath, String candidateVersion) {
        return this.deleteVersionFromFilename(requestPath, candidateVersion);
    }

    @Override
    public boolean resourceVersionMatches(Resource baseResource, String candidateVersion) {
        String resourceHash = this.calculateHash(baseResource);
        return candidateVersion.equals(resourceHash);
    }

    @Override
    public String addVersionToUrl(String baseUrl, List<? extends Resource> locations, ResourceResolverChain chain) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Getting the original resource to calculate hash");
        }
        Resource original = chain.resolveResource(null, baseUrl, locations);
        String hash = this.calculateHash(original);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Calculated hash=" + hash));
        }
        return this.addVersionToFilename(baseUrl, hash);
    }

    private String calculateHash(Resource resource) {
        try {
            byte[] content = FileCopyUtils.copyToByteArray((InputStream)resource.getInputStream());
            return DigestUtils.md5DigestAsHex((byte[])content);
        }
        catch (IOException e) {
            this.logger.error((Object)("Failed to calculate hash for resource [" + resource + "]"));
            return "";
        }
    }
}

