/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.resource.ResourceTransformer;
import org.springframework.web.servlet.resource.ResourceTransformerChain;
import org.springframework.web.servlet.resource.TransformedResource;

public class CssLinkResourceTransformer
implements ResourceTransformer {
    private static final Log logger = LogFactory.getLog(CssLinkResourceTransformer.class);
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private final List<CssLinkParser> linkParsers = new ArrayList<CssLinkParser>();

    public CssLinkResourceTransformer() {
        this.linkParsers.add(new ImportStatementCssLinkParser());
        this.linkParsers.add(new UrlFunctionCssLinkParser());
    }

    @Override
    public Resource transform(HttpServletRequest request, Resource resource, ResourceTransformerChain transformerChain) throws IOException {
        String filename = (resource = transformerChain.transform(request, resource)).getFilename();
        if (!"css".equals(StringUtils.getFilenameExtension((String)filename))) {
            return resource;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Transforming resource: " + resource));
        }
        byte[] bytes = FileCopyUtils.copyToByteArray((InputStream)resource.getInputStream());
        String content = new String(bytes, DEFAULT_CHARSET);
        HashSet<CssLinkInfo> infos = new HashSet<CssLinkInfo>(5);
        for (CssLinkParser parser : this.linkParsers) {
            parser.parseLink(content, infos);
        }
        if (infos.isEmpty()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"No links found.");
            }
            return resource;
        }
        ArrayList sortedInfos = new ArrayList(infos);
        Collections.sort(sortedInfos);
        int index = 0;
        StringWriter writer = new StringWriter();
        for (CssLinkInfo info : sortedInfos) {
            writer.write(content.substring(index, info.getStart()));
            String link = content.substring(info.getStart(), info.getEnd());
            String newLink = null;
            if (!this.hasScheme(link)) {
                newLink = transformerChain.getResolverChain().resolveUrlPath(link, Arrays.asList(resource));
            }
            if (logger.isTraceEnabled()) {
                if (newLink != null && !link.equals(newLink)) {
                    logger.trace((Object)("Link modified: " + newLink + " (original: " + link + ")"));
                } else {
                    logger.trace((Object)("Link not modified: " + link));
                }
            }
            writer.write(newLink != null ? newLink : link);
            index = info.getEnd();
        }
        writer.write(content.substring(index));
        return new TransformedResource(resource, writer.toString().getBytes(DEFAULT_CHARSET));
    }

    private boolean hasScheme(String link) {
        int schemeIndex = link.indexOf(":");
        return schemeIndex > 0 && !link.substring(0, schemeIndex).contains("/");
    }

    private static class CssLinkInfo
    implements Comparable<CssLinkInfo> {
        private final int start;
        private final int end;

        private CssLinkInfo(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        @Override
        public int compareTo(CssLinkInfo other) {
            return this.start < other.start ? -1 : (this.start == other.start ? 0 : 1);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj != null && obj instanceof CssLinkInfo) {
                CssLinkInfo other = (CssLinkInfo)obj;
                return this.start == other.start && this.end == other.end;
            }
            return false;
        }

        public int hashCode() {
            return this.start * 31 + this.end;
        }
    }

    private static class UrlFunctionCssLinkParser
    extends AbstractCssLinkParser {
        private UrlFunctionCssLinkParser() {
        }

        @Override
        protected String getKeyword() {
            return "url(";
        }

        @Override
        protected int extractLink(int index, String content, Set<CssLinkInfo> linkInfos) {
            return this.addLink(index - 1, ")", content, linkInfos);
        }
    }

    private static class ImportStatementCssLinkParser
    extends AbstractCssLinkParser {
        private ImportStatementCssLinkParser() {
        }

        @Override
        protected String getKeyword() {
            return "@import";
        }

        @Override
        protected int extractLink(int index, String content, Set<CssLinkInfo> linkInfos) {
            if (!content.substring(index, index + 4).equals("url(") && logger.isErrorEnabled()) {
                logger.error((Object)("Unexpected syntax for @import link at index " + index));
            }
            return index;
        }
    }

    protected static abstract class AbstractCssLinkParser
    implements CssLinkParser {
        protected AbstractCssLinkParser() {
        }

        protected abstract String getKeyword();

        @Override
        public void parseLink(String content, Set<CssLinkInfo> linkInfos) {
            int index = 0;
            while ((index = content.indexOf(this.getKeyword(), index)) != -1) {
                if (content.charAt(index = this.skipWhitespace(content, index + this.getKeyword().length())) == '\'') {
                    index = this.addLink(index, "'", content, linkInfos);
                    continue;
                }
                if (content.charAt(index) == '\"') {
                    index = this.addLink(index, "\"", content, linkInfos);
                    continue;
                }
                index = this.extractLink(index, content, linkInfos);
            }
        }

        private int skipWhitespace(String content, int index) {
            while (Character.isWhitespace(content.charAt(index))) {
                ++index;
            }
            return index;
        }

        protected int addLink(int index, String endKey, String content, Set<CssLinkInfo> linkInfos) {
            int start = index + 1;
            int end = content.indexOf(endKey, start);
            linkInfos.add(new CssLinkInfo(start, end));
            return end + endKey.length();
        }

        protected abstract int extractLink(int var1, String var2, Set<CssLinkInfo> var3);
    }

    protected static interface CssLinkParser {
        public void parseLink(String var1, Set<CssLinkInfo> var2);
    }
}

