/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import java.util.List;
import java.util.concurrent.Callable;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.web.servlet.resource.AbstractVersionStrategy;
import org.springframework.web.servlet.resource.ResourceResolverChain;

public class FixedVersionStrategy
extends AbstractVersionStrategy {
    private final String version;

    public FixedVersionStrategy(String fixedVersion) {
        Assert.hasText((String)fixedVersion, (String)"version must not be null or empty");
        this.version = fixedVersion.endsWith("/") ? fixedVersion : fixedVersion + "/";
    }

    public FixedVersionStrategy(Callable<String> versionInitializer) throws Exception {
        String fixedVersion = versionInitializer.call();
        Assert.hasText((String)fixedVersion, (String)"version must not be null or empty");
        this.version = fixedVersion.endsWith("/") ? fixedVersion : fixedVersion + "/";
    }

    @Override
    public String extractVersionFromPath(String requestPath) {
        return this.extractVersionAsPrefix(requestPath, this.version);
    }

    @Override
    public String deleteVersionFromPath(String requestPath, String candidateVersion) {
        return this.deleteVersionAsPrefix(requestPath, candidateVersion);
    }

    @Override
    public boolean resourceVersionMatches(Resource baseResource, String candidateVersion) {
        return this.version.equals(candidateVersion);
    }

    @Override
    public String addVersionToUrl(String baseUrl, List<? extends Resource> locations, ResourceResolverChain chain) {
        return this.addVersionAsPrefix(baseUrl, this.version);
    }
}

