/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.io.Resource;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.resource.AbstractResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolverChain;
import org.springframework.web.servlet.resource.VersionStrategy;

public class VersionResourceResolver
extends AbstractResourceResolver {
    private AntPathMatcher pathMatcher = new AntPathMatcher();
    private Map<String, VersionStrategy> versionStrategyMap = Collections.emptyMap();

    public void setVersionStrategyMap(Map<String, VersionStrategy> versionStrategyMap) {
        this.versionStrategyMap = versionStrategyMap;
    }

    @Override
    protected Resource resolveResourceInternal(HttpServletRequest request, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        Resource baseResource;
        Resource resolved = chain.resolveResource(request, requestPath, locations);
        if (resolved != null) {
            return resolved;
        }
        VersionStrategy versionStrategy = this.findStrategy(requestPath);
        if (versionStrategy == null) {
            return null;
        }
        String candidateVersion = versionStrategy.extractVersionFromPath(requestPath);
        if (StringUtils.isEmpty((Object)candidateVersion)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("No version found in path=\"" + requestPath + "\""));
            }
            return null;
        }
        String simplePath = versionStrategy.deleteVersionFromPath(requestPath, candidateVersion);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Extracted version from path, re-resolving without version, path=\"" + simplePath + "\""));
        }
        if ((baseResource = chain.resolveResource(request, simplePath, locations)) == null) {
            return null;
        }
        if (versionStrategy.resourceVersionMatches(baseResource, candidateVersion)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"resource matches extracted version");
            }
            return baseResource;
        }
        this.logger.trace((Object)("Potential resource found for [" + requestPath + "], but version [" + candidateVersion + "] doesn't match."));
        return null;
    }

    @Override
    protected String resolveUrlPathInternal(String resourceUrlPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        String baseUrl = chain.resolveUrlPath(resourceUrlPath, locations);
        if (StringUtils.hasText((String)baseUrl)) {
            VersionStrategy versionStrategy = this.findStrategy(resourceUrlPath);
            if (versionStrategy == null) {
                return null;
            }
            return versionStrategy.addVersionToUrl(baseUrl, locations, chain);
        }
        return baseUrl;
    }

    protected VersionStrategy findStrategy(String requestPath) {
        String path = "/".concat(requestPath);
        ArrayList<String> matchingPatterns = new ArrayList<String>();
        for (String pattern : this.versionStrategyMap.keySet()) {
            if (!this.pathMatcher.match(pattern, path)) continue;
            matchingPatterns.add(pattern);
        }
        if (!matchingPatterns.isEmpty()) {
            Comparator comparator = this.pathMatcher.getPatternComparator(path);
            Collections.sort(matchingPatterns, comparator);
            return this.versionStrategyMap.get(matchingPatterns.get(0));
        }
        return null;
    }
}

