/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.json;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.converter.json.MappingJacksonValue;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.servlet.view.AbstractView;

public class MappingJackson2JsonView
extends AbstractView {
    public static final String DEFAULT_CONTENT_TYPE = "application/json";
    public static final String DEFAULT_JSONP_CONTENT_TYPE = "application/javascript";
    private ObjectMapper objectMapper = new ObjectMapper();
    private JsonEncoding encoding = JsonEncoding.UTF8;
    private String jsonPrefix;
    private Boolean prettyPrint;
    private Set<String> modelKeys;
    private boolean extractValueFromSingleKeyModel = false;
    private boolean disableCaching = true;
    private boolean updateContentLength = false;
    private Set<String> jsonpParameterNames = new LinkedHashSet<String>(Arrays.asList("jsonp", "callback"));

    public MappingJackson2JsonView() {
        this.setContentType(DEFAULT_CONTENT_TYPE);
        this.setExposePathVariables(false);
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"'objectMapper' must not be null");
        this.objectMapper = objectMapper;
        this.configurePrettyPrint();
    }

    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setEncoding(JsonEncoding encoding) {
        Assert.notNull((Object)encoding, (String)"'encoding' must not be null");
        this.encoding = encoding;
    }

    public final JsonEncoding getEncoding() {
        return this.encoding;
    }

    public void setJsonPrefix(String jsonPrefix) {
        this.jsonPrefix = jsonPrefix;
    }

    public void setPrefixJson(boolean prefixJson) {
        this.jsonPrefix = prefixJson ? "{} && " : null;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
        this.configurePrettyPrint();
    }

    private void configurePrettyPrint() {
        if (this.prettyPrint != null) {
            this.objectMapper.configure(SerializationFeature.INDENT_OUTPUT, this.prettyPrint.booleanValue());
        }
    }

    public void setModelKey(String modelKey) {
        this.modelKeys = Collections.singleton(modelKey);
    }

    public void setModelKeys(Set<String> modelKeys) {
        this.modelKeys = modelKeys;
    }

    public final Set<String> getModelKeys() {
        return this.modelKeys;
    }

    @Deprecated
    public void setRenderedAttributes(Set<String> renderedAttributes) {
        this.modelKeys = renderedAttributes;
    }

    @Deprecated
    public final Set<String> getRenderedAttributes() {
        return this.modelKeys;
    }

    public void setExtractValueFromSingleKeyModel(boolean extractValueFromSingleKeyModel) {
        this.extractValueFromSingleKeyModel = extractValueFromSingleKeyModel;
    }

    public void setDisableCaching(boolean disableCaching) {
        this.disableCaching = disableCaching;
    }

    public void setUpdateContentLength(boolean updateContentLength) {
        this.updateContentLength = updateContentLength;
    }

    public void setJsonpParameterNames(Set<String> jsonpParameterNames) {
        this.jsonpParameterNames = jsonpParameterNames;
    }

    @Override
    protected void prepareResponse(HttpServletRequest request, HttpServletResponse response) {
        this.setResponseContentType(request, response);
        response.setCharacterEncoding(this.encoding.getJavaName());
        if (this.disableCaching) {
            response.addHeader("Pragma", "no-cache");
            response.addHeader("Cache-Control", "no-cache, no-store, max-age=0");
            response.addDateHeader("Expires", 1L);
        }
    }

    @Override
    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ByteArrayOutputStream stream = this.updateContentLength ? this.createTemporaryOutputStream() : response.getOutputStream();
        Class serializationView = (Class)model.get(JsonView.class.getName());
        String jsonpParameterValue = this.getJsonpParameterValue(request);
        Object value = this.filterModel(model);
        if (serializationView != null || jsonpParameterValue != null) {
            MappingJacksonValue container = new MappingJacksonValue(value);
            container.setSerializationView(serializationView);
            container.setJsonpFunction(jsonpParameterValue);
            value = container;
        }
        this.writeContent(stream, value, this.jsonPrefix);
        if (this.updateContentLength) {
            this.writeToResponse(response, stream);
        }
    }

    private String getJsonpParameterValue(HttpServletRequest request) {
        if (this.jsonpParameterNames != null) {
            for (String name : this.jsonpParameterNames) {
                String value = request.getParameter(name);
                if (StringUtils.isEmpty((Object)value)) continue;
                return value;
            }
        }
        return null;
    }

    protected Object filterModel(Map<String, Object> model) {
        HashMap<String, Object> result = new HashMap<String, Object>(model.size());
        Set<String> modelKeys = !CollectionUtils.isEmpty(this.modelKeys) ? this.modelKeys : model.keySet();
        for (Map.Entry<String, Object> entry : model.entrySet()) {
            if (entry.getValue() instanceof BindingResult || !modelKeys.contains(entry.getKey()) || entry.getKey().equals(JsonView.class.getName())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return this.extractValueFromSingleKeyModel && result.size() == 1 ? result.values().iterator().next() : result;
    }

    protected void writeContent(OutputStream stream, Object value, String jsonPrefix) throws IOException {
        JsonGenerator generator = this.objectMapper.getFactory().createGenerator(stream, this.encoding);
        if (jsonPrefix != null) {
            generator.writeRaw(jsonPrefix);
        }
        Class serializationView = null;
        String jsonpFunction = null;
        if (value instanceof MappingJacksonValue) {
            MappingJacksonValue container = (MappingJacksonValue)value;
            value = container.getValue();
            serializationView = container.getSerializationView();
            jsonpFunction = container.getJsonpFunction();
        }
        if (jsonpFunction != null) {
            generator.writeRaw(jsonpFunction + "(");
        }
        if (serializationView != null) {
            this.objectMapper.writerWithView(serializationView).writeValue(generator, value);
        } else {
            this.objectMapper.writeValue(generator, value);
        }
        if (jsonpFunction != null) {
            generator.writeRaw(");");
            generator.flush();
        }
    }

    @Override
    protected void setResponseContentType(HttpServletRequest request, HttpServletResponse response) {
        if (this.getJsonpParameterValue(request) != null) {
            response.setContentType(DEFAULT_JSONP_CONTENT_TYPE);
        } else {
            super.setResponseContentType(request, response);
        }
    }
}

