/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.UnsatisfiedServletRequestParameterException;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.AbstractHandlerMethodMapping;
import org.springframework.web.servlet.mvc.condition.NameValueExpression;
import org.springframework.web.servlet.mvc.condition.ParamsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMethodMappingNamingStrategy;
import org.springframework.web.util.WebUtils;

public abstract class RequestMappingInfoHandlerMapping
extends AbstractHandlerMethodMapping<RequestMappingInfo> {
    protected RequestMappingInfoHandlerMapping() {
        this.setHandlerMethodMappingNamingStrategy(new RequestMappingInfoHandlerMethodMappingNamingStrategy());
    }

    @Override
    protected Set<String> getMappingPathPatterns(RequestMappingInfo info) {
        return info.getPatternsCondition().getPatterns();
    }

    @Override
    protected RequestMappingInfo getMatchingMapping(RequestMappingInfo info, HttpServletRequest request) {
        return info.getMatchingCondition(request);
    }

    @Override
    protected Comparator<RequestMappingInfo> getMappingComparator(final HttpServletRequest request) {
        return new Comparator<RequestMappingInfo>(){

            @Override
            public int compare(RequestMappingInfo info1, RequestMappingInfo info2) {
                return info1.compareTo(info2, request);
            }
        };
    }

    @Override
    protected void handleMatch(RequestMappingInfo info, String lookupPath, HttpServletRequest request) {
        Map decodedUriVariables;
        Map uriVariables;
        String bestPattern;
        super.handleMatch(info, lookupPath, request);
        Set<String> patterns = info.getPatternsCondition().getPatterns();
        if (patterns.isEmpty()) {
            bestPattern = lookupPath;
            uriVariables = Collections.emptyMap();
            decodedUriVariables = Collections.emptyMap();
        } else {
            bestPattern = patterns.iterator().next();
            uriVariables = this.getPathMatcher().extractUriTemplateVariables(bestPattern, lookupPath);
            decodedUriVariables = this.getUrlPathHelper().decodePathVariables(request, uriVariables);
        }
        request.setAttribute(BEST_MATCHING_PATTERN_ATTRIBUTE, (Object)bestPattern);
        request.setAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, decodedUriVariables);
        if (this.isMatrixVariableContentAvailable()) {
            Map<String, MultiValueMap<String, String>> matrixVars = this.extractMatrixVariables(request, uriVariables);
            request.setAttribute(HandlerMapping.MATRIX_VARIABLES_ATTRIBUTE, matrixVars);
        }
        if (!info.getProducesCondition().getProducibleMediaTypes().isEmpty()) {
            Set<MediaType> mediaTypes = info.getProducesCondition().getProducibleMediaTypes();
            request.setAttribute(PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE, mediaTypes);
        }
    }

    private boolean isMatrixVariableContentAvailable() {
        return !this.getUrlPathHelper().shouldRemoveSemicolonContent();
    }

    private Map<String, MultiValueMap<String, String>> extractMatrixVariables(HttpServletRequest request, Map<String, String> uriVariables) {
        LinkedHashMap<String, MultiValueMap<String, String>> result = new LinkedHashMap<String, MultiValueMap<String, String>>();
        for (Map.Entry<String, String> uriVar : uriVariables.entrySet()) {
            String matrixVariables;
            String uriVarValue = uriVar.getValue();
            int equalsIndex = uriVarValue.indexOf(61);
            if (equalsIndex == -1) continue;
            int semicolonIndex = uriVarValue.indexOf(59);
            if (semicolonIndex == -1 || semicolonIndex == 0 || equalsIndex < semicolonIndex) {
                matrixVariables = uriVarValue;
            } else {
                matrixVariables = uriVarValue.substring(semicolonIndex + 1);
                uriVariables.put(uriVar.getKey(), uriVarValue.substring(0, semicolonIndex));
            }
            MultiValueMap vars = WebUtils.parseMatrixVariables((String)matrixVariables);
            result.put(uriVar.getKey(), (MultiValueMap<String, String>)this.getUrlPathHelper().decodeMatrixVariables(request, vars));
        }
        return result;
    }

    @Override
    protected HandlerMethod handleNoMatch(Set<RequestMappingInfo> requestMappingInfos, String lookupPath, HttpServletRequest request) throws ServletException {
        List<String[]> paramConditions;
        Set<MediaType> producibleMediaTypes;
        Set<MediaType> consumableMediaTypes;
        LinkedHashSet<String> allowedMethods = new LinkedHashSet<String>(4);
        HashSet<RequestMappingInfo> patternMatches = new HashSet<RequestMappingInfo>();
        HashSet<RequestMappingInfo> patternAndMethodMatches = new HashSet<RequestMappingInfo>();
        for (RequestMappingInfo info : requestMappingInfos) {
            if (info.getPatternsCondition().getMatchingCondition(request) == null) continue;
            patternMatches.add(info);
            if (info.getMethodsCondition().getMatchingCondition(request) != null) {
                patternAndMethodMatches.add(info);
                continue;
            }
            for (RequestMethod method : info.getMethodsCondition().getMethods()) {
                allowedMethods.add(method.name());
            }
        }
        if (patternMatches.isEmpty()) {
            return null;
        }
        if (patternAndMethodMatches.isEmpty() && !allowedMethods.isEmpty()) {
            throw new HttpRequestMethodNotSupportedException(request.getMethod(), allowedMethods);
        }
        if (patternAndMethodMatches.isEmpty()) {
            consumableMediaTypes = this.getConsumableMediaTypes(request, patternMatches);
            producibleMediaTypes = this.getProducibleMediaTypes(request, patternMatches);
            paramConditions = this.getRequestParams(request, patternMatches);
        } else {
            consumableMediaTypes = this.getConsumableMediaTypes(request, patternAndMethodMatches);
            producibleMediaTypes = this.getProducibleMediaTypes(request, patternAndMethodMatches);
            paramConditions = this.getRequestParams(request, patternAndMethodMatches);
        }
        if (!consumableMediaTypes.isEmpty()) {
            MediaType contentType = null;
            if (StringUtils.hasLength((String)request.getContentType())) {
                try {
                    contentType = MediaType.parseMediaType((String)request.getContentType());
                }
                catch (InvalidMediaTypeException ex) {
                    throw new HttpMediaTypeNotSupportedException(ex.getMessage());
                }
            }
            throw new HttpMediaTypeNotSupportedException(contentType, new ArrayList<MediaType>(consumableMediaTypes));
        }
        if (!producibleMediaTypes.isEmpty()) {
            throw new HttpMediaTypeNotAcceptableException(new ArrayList<MediaType>(producibleMediaTypes));
        }
        if (!CollectionUtils.isEmpty(paramConditions)) {
            throw new UnsatisfiedServletRequestParameterException(paramConditions, request.getParameterMap());
        }
        return null;
    }

    private Set<MediaType> getConsumableMediaTypes(HttpServletRequest request, Set<RequestMappingInfo> partialMatches) {
        HashSet<MediaType> result = new HashSet<MediaType>();
        for (RequestMappingInfo partialMatch : partialMatches) {
            if (partialMatch.getConsumesCondition().getMatchingCondition(request) != null) continue;
            result.addAll(partialMatch.getConsumesCondition().getConsumableMediaTypes());
        }
        return result;
    }

    private Set<MediaType> getProducibleMediaTypes(HttpServletRequest request, Set<RequestMappingInfo> partialMatches) {
        HashSet<MediaType> result = new HashSet<MediaType>();
        for (RequestMappingInfo partialMatch : partialMatches) {
            if (partialMatch.getProducesCondition().getMatchingCondition(request) != null) continue;
            result.addAll(partialMatch.getProducesCondition().getProducibleMediaTypes());
        }
        return result;
    }

    private List<String[]> getRequestParams(HttpServletRequest request, Set<RequestMappingInfo> partialMatches) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (RequestMappingInfo partialMatch : partialMatches) {
            ParamsRequestCondition condition = partialMatch.getParamsCondition();
            Set<NameValueExpression<String>> expressions = condition.getExpressions();
            if (CollectionUtils.isEmpty(expressions) || condition.getMatchingCondition(request) != null) continue;
            int i = 0;
            String[] array = new String[expressions.size()];
            for (NameValueExpression<String> expression : expressions) {
                array[i++] = expression.toString();
            }
            result.add(array);
        }
        return result;
    }
}

