/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.messaging;

import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.Assert;
import org.springframework.web.socket.messaging.SubProtocolErrorHandler;

public class StompSubProtocolErrorHandler
implements SubProtocolErrorHandler<byte[]> {
    private static byte[] EMPTY_PAYLOAD = new byte[0];

    @Override
    public Message<byte[]> handleClientMessageProcessingError(Message<byte[]> clientMessage, Throwable ex) {
        String receiptId;
        StompHeaderAccessor accessor = StompHeaderAccessor.create((StompCommand)StompCommand.ERROR);
        accessor.setMessage(ex.getMessage());
        accessor.setLeaveMutable(true);
        StompHeaderAccessor clientHeaderAccessor = null;
        if (clientMessage != null && (receiptId = (clientHeaderAccessor = (StompHeaderAccessor)MessageHeaderAccessor.getAccessor(clientMessage, StompHeaderAccessor.class)).getReceipt()) != null) {
            accessor.setReceiptId(receiptId);
        }
        return this.handleInternal(accessor, EMPTY_PAYLOAD, ex, clientHeaderAccessor);
    }

    @Override
    public Message<byte[]> handleErrorMessageToClient(Message<byte[]> errorMessage) {
        StompHeaderAccessor accessor = (StompHeaderAccessor)MessageHeaderAccessor.getAccessor(errorMessage, StompHeaderAccessor.class);
        Assert.notNull((Object)accessor, (String)"Expected STOMP headers.");
        if (!accessor.isMutable()) {
            accessor = StompHeaderAccessor.wrap(errorMessage);
        }
        return this.handleInternal(accessor, (byte[])errorMessage.getPayload(), null, null);
    }

    protected Message<byte[]> handleInternal(StompHeaderAccessor errorHeaderAccessor, byte[] errorPayload, Throwable cause, StompHeaderAccessor clientHeaderAccessor) {
        return MessageBuilder.createMessage((Object)errorPayload, (MessageHeaders)errorHeaderAccessor.getMessageHeaders());
    }
}

