/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.client;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.List;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.SettableListenableFuture;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketExtension;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.sockjs.client.AbstractClientSockJsSession;
import org.springframework.web.socket.sockjs.client.TransportRequest;
import org.springframework.web.socket.sockjs.client.XhrTransport;
import org.springframework.web.socket.sockjs.transport.TransportType;

public class XhrClientSockJsSession
extends AbstractClientSockJsSession {
    private final URI sendUrl;
    private final XhrTransport transport;
    private int textMessageSizeLimit = -1;
    private int binaryMessageSizeLimit = -1;

    public XhrClientSockJsSession(TransportRequest request, WebSocketHandler handler, XhrTransport transport, SettableListenableFuture<WebSocketSession> connectFuture) {
        super(request, handler, connectFuture);
        Assert.notNull((Object)transport, (String)"'restTemplate' is required");
        this.sendUrl = request.getSockJsUrlInfo().getTransportUrl(TransportType.XHR_SEND);
        this.transport = transport;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return null;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return new InetSocketAddress(this.getUri().getHost(), this.getUri().getPort());
    }

    @Override
    public String getAcceptedProtocol() {
        return null;
    }

    @Override
    public void setTextMessageSizeLimit(int messageSizeLimit) {
        this.textMessageSizeLimit = messageSizeLimit;
    }

    @Override
    public int getTextMessageSizeLimit() {
        return this.textMessageSizeLimit;
    }

    @Override
    public void setBinaryMessageSizeLimit(int messageSizeLimit) {
        this.binaryMessageSizeLimit = -1;
    }

    @Override
    public int getBinaryMessageSizeLimit() {
        return this.binaryMessageSizeLimit;
    }

    @Override
    public List<WebSocketExtension> getExtensions() {
        return null;
    }

    @Override
    protected void sendInternal(TextMessage message) {
        this.transport.executeSendRequest(this.sendUrl, message);
    }

    @Override
    protected void disconnect(CloseStatus status) {
    }
}

