/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.standard;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.websocket.server.ServerContainer;
import jakarta.websocket.server.ServerEndpointConfig;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.web.socket.server.standard.StandardWebSocketUpgradeStrategy;

public class WebSphereRequestUpgradeStrategy
extends StandardWebSocketUpgradeStrategy {
    private static final Method upgradeMethod;

    @Override
    protected void upgradeHttpToWebSocket(HttpServletRequest request, HttpServletResponse response, ServerEndpointConfig endpointConfig, Map<String, String> pathParams) throws Exception {
        ServerContainer container = this.getContainer(request);
        upgradeMethod.invoke((Object)container, request, response, endpointConfig, pathParams);
    }

    static {
        ClassLoader loader = WebSphereRequestUpgradeStrategy.class.getClassLoader();
        try {
            Class<?> type = loader.loadClass("com.ibm.websphere.wsoc.WsWsocServerContainer");
            upgradeMethod = type.getMethod("doUpgrade", HttpServletRequest.class, HttpServletResponse.class, ServerEndpointConfig.class, Map.class);
        }
        catch (Exception ex) {
            throw new IllegalStateException("No compatible WebSphere version found", ex);
        }
    }
}

