/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.ojb;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.ojb.PersistenceBrokerHolder;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class OjbFactoryUtils {
    public static final int PERSISTENCE_BROKER_SYNCHRONIZATION_ORDER = 900;
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$orm$ojb$OjbFactoryUtils == null ? (class$org$springframework$orm$ojb$OjbFactoryUtils = OjbFactoryUtils.class$("org.springframework.orm.ojb.OjbFactoryUtils")) : class$org$springframework$orm$ojb$OjbFactoryUtils));
    static /* synthetic */ Class class$org$springframework$orm$ojb$OjbFactoryUtils;

    public static PersistenceBroker getPersistenceBroker(PBKey pbKey, boolean allowCreate) throws DataAccessResourceFailureException, IllegalStateException {
        return OjbFactoryUtils.getPersistenceBroker(pbKey, allowCreate, true);
    }

    public static PersistenceBroker getPersistenceBroker(PBKey pbKey, boolean allowCreate, boolean allowSynchronization) throws DataAccessResourceFailureException, IllegalStateException {
        PersistenceBrokerHolder pbHolder = (PersistenceBrokerHolder)TransactionSynchronizationManager.getResource(pbKey);
        if (pbHolder != null) {
            return pbHolder.getPersistenceBroker();
        }
        if (!allowCreate) {
            throw new IllegalStateException("No OJB persistence broker bound to thread, and configuration does not allow creation of new one here");
        }
        logger.debug((Object)"Opening OJB persistence broker");
        try {
            PersistenceBroker pb = PersistenceBrokerFactory.createPersistenceBroker((PBKey)pbKey);
            if (allowSynchronization && TransactionSynchronizationManager.isSynchronizationActive()) {
                logger.debug((Object)"Registering transaction synchronization for OJB persistence broker");
                pbHolder = new PersistenceBrokerHolder(pb);
                TransactionSynchronizationManager.bindResource(pbKey, pbHolder);
                TransactionSynchronizationManager.registerSynchronization(new PersistenceBrokerSynchronization(pbHolder, pbKey));
            }
            return pb;
        }
        catch (OJBRuntimeException ex) {
            throw new DataAccessResourceFailureException("Could not open OJB persistence broker", ex);
        }
    }

    public static void closePersistenceBrokerIfNecessary(PersistenceBroker pb, PBKey pbKey) {
        if (pb == null) {
            return;
        }
        PersistenceBrokerHolder pbHolder = (PersistenceBrokerHolder)TransactionSynchronizationManager.getResource(pbKey);
        if (pbHolder != null && pb == pbHolder.getPersistenceBroker()) {
            return;
        }
        logger.debug((Object)"Closing OJB persistence broker");
        pb.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PersistenceBrokerSynchronization
    extends TransactionSynchronizationAdapter {
        private final PersistenceBrokerHolder persistenceBrokerHolder;
        private final PBKey pbKey;

        private PersistenceBrokerSynchronization(PersistenceBrokerHolder pbHolder, PBKey pbKey) {
            this.persistenceBrokerHolder = pbHolder;
            this.pbKey = pbKey;
        }

        public int getOrder() {
            return 900;
        }

        public void suspend() {
            TransactionSynchronizationManager.unbindResource(this.pbKey);
        }

        public void resume() {
            TransactionSynchronizationManager.bindResource(this.pbKey, this.persistenceBrokerHolder);
        }

        public void beforeCompletion() {
            TransactionSynchronizationManager.unbindResource(this.pbKey);
            OjbFactoryUtils.closePersistenceBrokerIfNecessary(this.persistenceBrokerHolder.getPersistenceBroker(), this.pbKey);
        }
    }
}

