/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.ConnectionProxy;
import org.springframework.jdbc.datasource.SmartDataSource;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public abstract class DataSourceUtils {
    public static final int CONNECTION_SYNCHRONIZATION_ORDER = 1000;
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$jdbc$datasource$DataSourceUtils == null ? (class$org$springframework$jdbc$datasource$DataSourceUtils = DataSourceUtils.class$("org.springframework.jdbc.datasource.DataSourceUtils")) : class$org$springframework$jdbc$datasource$DataSourceUtils));
    static /* synthetic */ Class class$org$springframework$jdbc$datasource$DataSourceUtils;

    public static Connection getConnection(DataSource dataSource) throws CannotGetJdbcConnectionException {
        return DataSourceUtils.getConnection(dataSource, true);
    }

    public static Connection getConnection(DataSource dataSource, boolean allowSynchronization) throws CannotGetJdbcConnectionException {
        try {
            return DataSourceUtils.doGetConnection(dataSource, allowSynchronization);
        }
        catch (SQLException ex) {
            throw new CannotGetJdbcConnectionException("Could not get JDBC connection", ex);
        }
    }

    public static Connection doGetConnection(DataSource dataSource) throws SQLException {
        return DataSourceUtils.doGetConnection(dataSource, true);
    }

    public static Connection doGetConnection(DataSource dataSource, boolean allowSynchronization) throws SQLException {
        Assert.notNull(dataSource, "No DataSource specified");
        ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource(dataSource);
        if (conHolder != null) {
            conHolder.requested();
            return conHolder.getConnection();
        }
        logger.debug((Object)"Opening JDBC connection");
        Connection con = dataSource.getConnection();
        if (allowSynchronization && TransactionSynchronizationManager.isSynchronizationActive()) {
            logger.debug((Object)"Registering transaction synchronization for JDBC connection");
            conHolder = new ConnectionHolder(con);
            TransactionSynchronizationManager.bindResource(dataSource, conHolder);
            TransactionSynchronizationManager.registerSynchronization(new ConnectionSynchronization(conHolder, dataSource));
            conHolder.requested();
        }
        return con;
    }

    public static Integer prepareConnectionForTransaction(Connection con, TransactionDefinition definition) throws SQLException {
        Assert.notNull(con, "No connection specified");
        if (definition != null && definition.isReadOnly()) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Setting JDBC connection [" + con + "] read-only"));
                }
                con.setReadOnly(true);
            }
            catch (Exception ex) {
                logger.debug((Object)"Could not set JDBC connection read-only", (Throwable)ex);
            }
        }
        Integer previousIsolationLevel = null;
        if (definition != null && definition.getIsolationLevel() != -1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Changing isolation level of JDBC connection [" + con + "] to " + definition.getIsolationLevel()));
            }
            previousIsolationLevel = new Integer(con.getTransactionIsolation());
            con.setTransactionIsolation(definition.getIsolationLevel());
        }
        return previousIsolationLevel;
    }

    public static void resetConnectionAfterTransaction(Connection con, Integer previousIsolationLevel) {
        Assert.notNull(con, "No connection specified");
        try {
            if (previousIsolationLevel != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Resetting isolation level of connection [" + con + "] to " + previousIsolationLevel));
                }
                con.setTransactionIsolation(previousIsolationLevel);
            }
            if (con.isReadOnly()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Resetting read-only flag of connection [" + con + "]"));
                }
                con.setReadOnly(false);
            }
        }
        catch (Exception ex) {
            logger.info((Object)"Could not reset JDBC connection after transaction", (Throwable)ex);
        }
    }

    public static void applyTransactionTimeout(Statement stmt, DataSource dataSource) throws SQLException {
        Assert.notNull(stmt, "No statement specified");
        ConnectionHolder holder = (ConnectionHolder)TransactionSynchronizationManager.getResource(dataSource);
        if (holder != null && holder.hasTimeout()) {
            stmt.setQueryTimeout(holder.getTimeToLiveInSeconds());
        }
    }

    public static void closeConnectionIfNecessary(Connection con, DataSource dataSource) {
        try {
            DataSourceUtils.doCloseConnectionIfNecessary(con, dataSource);
        }
        catch (SQLException ex) {
            logger.error((Object)"Could not close JDBC connection", (Throwable)ex);
        }
    }

    public static void doCloseConnectionIfNecessary(Connection con, DataSource dataSource) throws SQLException {
        if (con == null) {
            return;
        }
        ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource(dataSource);
        if (conHolder != null && DataSourceUtils.connectionEquals(conHolder.getConnection(), con)) {
            conHolder.released();
            return;
        }
        if (!(dataSource instanceof SmartDataSource) || ((SmartDataSource)dataSource).shouldClose(con)) {
            logger.debug((Object)"Closing JDBC connection");
            con.close();
        }
    }

    private static boolean connectionEquals(Connection heldCon, Connection passedInCon) {
        return heldCon == passedInCon || heldCon.equals(passedInCon) || DataSourceUtils.getTargetConnection(heldCon).equals(passedInCon);
    }

    public static Connection getTargetConnection(Connection con) {
        Connection conToUse = con;
        while (conToUse instanceof ConnectionProxy) {
            conToUse = ((ConnectionProxy)conToUse).getTargetConnection();
        }
        return conToUse;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ConnectionSynchronization
    extends TransactionSynchronizationAdapter {
        private final ConnectionHolder connectionHolder;
        private final DataSource dataSource;

        public ConnectionSynchronization(ConnectionHolder connectionHolder, DataSource dataSource) {
            this.connectionHolder = connectionHolder;
            this.dataSource = dataSource;
        }

        public int getOrder() {
            return 1000;
        }

        public void suspend() {
            TransactionSynchronizationManager.unbindResource(this.dataSource);
        }

        public void resume() {
            TransactionSynchronizationManager.bindResource(this.dataSource, this.connectionHolder);
        }

        public void beforeCompletion() {
            if (!this.connectionHolder.isOpen()) {
                TransactionSynchronizationManager.unbindResource(this.dataSource);
                DataSourceUtils.closeConnectionIfNecessary(this.connectionHolder.getConnection(), this.dataSource);
            }
        }

        public void afterCompletion(int status) {
            if (TransactionSynchronizationManager.hasResource(this.dataSource)) {
                TransactionSynchronizationManager.unbindResource(this.dataSource);
                DataSourceUtils.closeConnectionIfNecessary(this.connectionHolder.getConnection(), this.dataSource);
            }
        }
    }
}

