/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.io.Serializable;
import org.springframework.core.AttributeAccessorSupport;
import org.springframework.util.ObjectUtils;

public class PropertyValue
extends AttributeAccessorSupport
implements Serializable {
    private final String name;
    private final Object value;
    private Object source;

    public PropertyValue(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("Property name cannot be null");
        }
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return "PropertyValue: name='" + this.name + "', value=[" + this.value + "]";
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PropertyValue)) {
            return false;
        }
        PropertyValue otherPv = (PropertyValue)other;
        return this.name.equals(otherPv.name) && ObjectUtils.nullSafeEquals(this.value, otherPv.value) && ObjectUtils.nullSafeEquals(this.source, otherPv.source);
    }

    public int hashCode() {
        return this.name.hashCode() * 29 + (this.value == null ? 0 : this.value.hashCode());
    }
}

