/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;
import org.springframework.util.SystemPropertyUtils;

public class ResourceEditor
extends PropertyEditorSupport {
    private final ResourceLoader resourceLoader;

    public ResourceEditor() {
        this.resourceLoader = new DefaultResourceLoader();
    }

    public ResourceEditor(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setAsText(String text) {
        if (StringUtils.hasText(text)) {
            String locationToUse = this.resolvePath(text).trim();
            this.setValue(this.resourceLoader.getResource(locationToUse));
        } else {
            this.setValue(null);
        }
    }

    protected String resolvePath(String path) {
        return SystemPropertyUtils.resolvePlaceholders(path);
    }

    public String getAsText() {
        Resource value = (Resource)this.getValue();
        try {
            return value != null ? value.getURL().toExternalForm() : "";
        }
        catch (IOException ex) {
            return null;
        }
    }
}

