/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.support;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.Constants;

public class MBeanRegistrationSupport {
    public static final int REGISTRATION_FAIL_ON_EXISTING = 0;
    public static final int REGISTRATION_IGNORE_EXISTING = 1;
    public static final int REGISTRATION_REPLACE_EXISTING = 2;
    private static final Constants constants = new Constants(class$org$springframework$jmx$support$MBeanRegistrationSupport == null ? (class$org$springframework$jmx$support$MBeanRegistrationSupport = MBeanRegistrationSupport.class$("org.springframework.jmx.support.MBeanRegistrationSupport")) : class$org$springframework$jmx$support$MBeanRegistrationSupport);
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected MBeanServer server;
    protected Set registeredBeans = new HashSet();
    private int registrationBehavior = 0;
    static /* synthetic */ Class class$org$springframework$jmx$support$MBeanRegistrationSupport;

    public void setServer(MBeanServer server) {
        this.server = server;
    }

    public void setRegistrationBehaviorName(String registrationBehavior) {
        this.setRegistrationBehavior(constants.asNumber(registrationBehavior).intValue());
    }

    public void setRegistrationBehavior(int registrationBehavior) {
        this.registrationBehavior = registrationBehavior;
    }

    protected void doRegister(Object mbean, ObjectName objectName) throws JMException {
        ObjectName actualObjectName;
        ObjectInstance registeredBean = null;
        try {
            registeredBean = this.server.registerMBean(mbean, objectName);
        }
        catch (InstanceAlreadyExistsException ex) {
            if (this.registrationBehavior == 1) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Ignoring existing MBean at [" + objectName + "]"));
                }
            }
            if (this.registrationBehavior == 2) {
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Replacing existing MBean at [" + objectName + "]"));
                    }
                    this.server.unregisterMBean(objectName);
                    registeredBean = this.server.registerMBean(mbean, objectName);
                }
                catch (InstanceNotFoundException ex2) {
                    this.logger.error((Object)("Unable to replace existing MBean at [" + objectName + "]"), (Throwable)ex2);
                    throw ex;
                }
            }
            throw ex;
        }
        ObjectName objectName2 = actualObjectName = registeredBean != null ? registeredBean.getObjectName() : null;
        if (actualObjectName == null) {
            actualObjectName = objectName;
        }
        this.registeredBeans.add(actualObjectName);
        this.onRegister(actualObjectName);
    }

    protected void unregisterBeans() {
        Iterator it = this.registeredBeans.iterator();
        while (it.hasNext()) {
            ObjectName objectName = (ObjectName)it.next();
            try {
                if (this.server.isRegistered(objectName)) {
                    this.server.unregisterMBean(objectName);
                    this.onUnregister(objectName);
                    continue;
                }
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn((Object)("Could not unregister MBean [" + objectName + "] as said MBean " + "is not registered (perhaps already unregistered by an external process)"));
            }
            catch (JMException ex) {
                if (!this.logger.isErrorEnabled()) continue;
                this.logger.error((Object)("Could not unregister MBean [" + objectName + "]"), (Throwable)ex);
            }
        }
        this.registeredBeans.clear();
    }

    protected void onRegister(ObjectName objectName) {
    }

    protected void onUnregister(ObjectName objectName) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

