/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import javax.persistence.RollbackException;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.datasource.ConnectionHandle;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.JdbcTransactionObjectSupport;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.orm.jpa.DefaultJpaDialect;
import org.springframework.orm.jpa.EntityManagerFactoryInfo;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.ResourceTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.CollectionUtils;

public class JpaTransactionManager
extends AbstractPlatformTransactionManager
implements ResourceTransactionManager,
InitializingBean {
    private EntityManagerFactory entityManagerFactory;
    private final Map jpaPropertyMap = new HashMap();
    private DataSource dataSource;
    private JpaDialect jpaDialect = new DefaultJpaDialect();

    public JpaTransactionManager() {
    }

    public JpaTransactionManager(EntityManagerFactory emf) {
        this.entityManagerFactory = emf;
        this.afterPropertiesSet();
    }

    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.entityManagerFactory = emf;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void setJpaProperties(Properties jpaProperties) {
        CollectionUtils.mergePropertiesIntoMap(jpaProperties, this.jpaPropertyMap);
    }

    public void setJpaPropertyMap(Map jpaProperties) {
        if (jpaProperties != null) {
            this.jpaPropertyMap.putAll(jpaProperties);
        }
    }

    public Map getJpaPropertyMap() {
        return this.jpaPropertyMap;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource instanceof TransactionAwareDataSourceProxy ? ((TransactionAwareDataSourceProxy)dataSource).getTargetDataSource() : dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setJpaDialect(JpaDialect jpaDialect) {
        this.jpaDialect = jpaDialect != null ? jpaDialect : new DefaultJpaDialect();
    }

    public JpaDialect getJpaDialect() {
        return this.jpaDialect;
    }

    public void afterPropertiesSet() {
        if (this.getEntityManagerFactory() == null) {
            throw new IllegalArgumentException("Property 'entityManagerFactory' is required");
        }
        if (this.getEntityManagerFactory() instanceof EntityManagerFactoryInfo) {
            JpaDialect jpaDialect;
            EntityManagerFactoryInfo emfInfo = (EntityManagerFactoryInfo)this.getEntityManagerFactory();
            DataSource dataSource = emfInfo.getDataSource();
            if (dataSource != null) {
                this.setDataSource(dataSource);
            }
            if ((jpaDialect = emfInfo.getJpaDialect()) != null) {
                this.setJpaDialect(jpaDialect);
            }
        }
    }

    public Object getResourceFactory() {
        return this.getEntityManagerFactory();
    }

    protected Object doGetTransaction() {
        JpaTransactionObject txObject = new JpaTransactionObject();
        txObject.setSavepointAllowed(this.isNestedTransactionAllowed());
        EntityManagerHolder emHolder = (EntityManagerHolder)TransactionSynchronizationManager.getResource(this.getEntityManagerFactory());
        if (emHolder != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found thread-bound EntityManager [" + emHolder.getEntityManager() + "] for JPA transaction"));
            }
            txObject.setEntityManagerHolder(emHolder, false);
        }
        if (this.getDataSource() != null) {
            ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource(this.getDataSource());
            txObject.setConnectionHolder(conHolder);
        }
        return txObject;
    }

    protected boolean isExistingTransaction(Object transaction) {
        return ((JpaTransactionObject)transaction).hasTransaction();
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        JpaTransactionObject txObject = (JpaTransactionObject)transaction;
        if (txObject.hasConnectionHolder() && !txObject.getConnectionHolder().isSynchronizedWithTransaction()) {
            throw new IllegalTransactionStateException("Pre-bound JDBC Connection found! JpaTransactionManager does not support running within DataSourceTransactionManager if told to manage the DataSource itself. It is recommended to use a single JpaTransactionManager for all transactions on a single DataSource, no matter whether JPA or JDBC access.");
        }
        EntityManager em = null;
        try {
            if (txObject.getEntityManagerHolder() == null || txObject.getEntityManagerHolder().isSynchronizedWithTransaction()) {
                EntityManager newEm = this.createEntityManagerForTransaction();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Opened new EntityManager [" + newEm + "] for JPA transaction"));
                }
                txObject.setEntityManagerHolder(new EntityManagerHolder(newEm), true);
            }
            em = txObject.getEntityManagerHolder().getEntityManager();
            Object transactionData = this.getJpaDialect().beginTransaction(em, definition);
            txObject.setTransactionData(transactionData);
            int timeout = this.determineTimeout(definition);
            if (timeout != -1) {
                txObject.getEntityManagerHolder().setTimeoutInSeconds(timeout);
            }
            if (this.getDataSource() != null) {
                ConnectionHandle conHandle = this.getJpaDialect().getJdbcConnection(em, definition.isReadOnly());
                if (conHandle != null) {
                    ConnectionHolder conHolder = new ConnectionHolder(conHandle);
                    if (timeout != -1) {
                        conHolder.setTimeoutInSeconds(timeout);
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Exposing JPA transaction as JDBC transaction [" + conHolder.getConnectionHandle() + "]"));
                    }
                    TransactionSynchronizationManager.bindResource(this.getDataSource(), conHolder);
                    txObject.setConnectionHolder(conHolder);
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Not exposing JPA transaction [" + em + "] as JDBC transaction because JpaDialect [" + this.getJpaDialect() + "] does not support JDBC Connection retrieval"));
                }
            }
            if (txObject.isNewEntityManagerHolder()) {
                TransactionSynchronizationManager.bindResource(this.getEntityManagerFactory(), txObject.getEntityManagerHolder());
            }
            txObject.getEntityManagerHolder().setSynchronizedWithTransaction(true);
        }
        catch (TransactionException ex) {
            if (txObject.isNewEntityManagerHolder()) {
                em.close();
            }
            throw ex;
        }
        catch (Exception ex) {
            if (txObject.isNewEntityManagerHolder()) {
                em.close();
            }
            throw new CannotCreateTransactionException("Could not open JPA EntityManager for transaction", ex);
        }
    }

    protected EntityManager createEntityManagerForTransaction() {
        Map properties;
        EntityManagerFactory emf = this.getEntityManagerFactory();
        if (emf instanceof EntityManagerFactoryInfo) {
            emf = ((EntityManagerFactoryInfo)emf).getNativeEntityManagerFactory();
        }
        return !CollectionUtils.isEmpty(properties = this.getJpaPropertyMap()) ? emf.createEntityManager(properties) : emf.createEntityManager();
    }

    protected Object doSuspend(Object transaction) {
        JpaTransactionObject txObject = (JpaTransactionObject)transaction;
        txObject.setEntityManagerHolder(null, false);
        EntityManagerHolder entityManagerHolder = (EntityManagerHolder)TransactionSynchronizationManager.unbindResource(this.getEntityManagerFactory());
        txObject.setConnectionHolder(null);
        ConnectionHolder connectionHolder = null;
        if (this.getDataSource() != null) {
            connectionHolder = (ConnectionHolder)TransactionSynchronizationManager.unbindResource(this.getDataSource());
        }
        return new SuspendedResourcesHolder(entityManagerHolder, connectionHolder);
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        SuspendedResourcesHolder resourcesHolder = (SuspendedResourcesHolder)suspendedResources;
        TransactionSynchronizationManager.bindResource(this.getEntityManagerFactory(), resourcesHolder.getEntityManagerHolder());
        if (this.getDataSource() != null) {
            TransactionSynchronizationManager.bindResource(this.getDataSource(), resourcesHolder.getConnectionHolder());
        }
    }

    protected boolean shouldCommitOnGlobalRollbackOnly() {
        return true;
    }

    protected void doCommit(DefaultTransactionStatus status) {
        JpaTransactionObject txObject = (JpaTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Committing JPA transaction on EntityManager [" + txObject.getEntityManagerHolder().getEntityManager() + "]"));
        }
        try {
            EntityTransaction tx = txObject.getEntityManagerHolder().getEntityManager().getTransaction();
            tx.commit();
        }
        catch (RollbackException ex) {
            DataAccessException dex;
            if (ex.getCause() instanceof RuntimeException && (dex = this.getJpaDialect().translateExceptionIfPossible((RuntimeException)ex.getCause())) != null) {
                throw dex;
            }
            throw new TransactionSystemException("Could not commit JPA transaction", ex);
        }
        catch (RuntimeException ex) {
            throw DataAccessUtils.translateIfNecessary(ex, this.getJpaDialect());
        }
    }

    protected void doRollback(DefaultTransactionStatus status) {
        JpaTransactionObject txObject = (JpaTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Rolling back JPA transaction on EntityManager [" + txObject.getEntityManagerHolder().getEntityManager() + "]"));
        }
        try {
            EntityTransaction tx = txObject.getEntityManagerHolder().getEntityManager().getTransaction();
            if (tx.isActive()) {
                tx.rollback();
            }
        }
        catch (PersistenceException ex) {
            throw new TransactionSystemException("Could not roll back JPA transaction", ex);
        }
        finally {
            if (!txObject.isNewEntityManagerHolder()) {
                txObject.getEntityManagerHolder().getEntityManager().clear();
            }
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        JpaTransactionObject txObject = (JpaTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Setting JPA transaction on EntityManager [" + txObject.getEntityManagerHolder().getEntityManager() + "] rollback-only"));
        }
        txObject.setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        JpaTransactionObject txObject = (JpaTransactionObject)transaction;
        if (txObject.isNewEntityManagerHolder()) {
            TransactionSynchronizationManager.unbindResource(this.getEntityManagerFactory());
        }
        txObject.getEntityManagerHolder().clear();
        if (txObject.hasConnectionHolder()) {
            TransactionSynchronizationManager.unbindResource(this.getDataSource());
            try {
                this.getJpaDialect().releaseJdbcConnection(txObject.getConnectionHolder().getConnectionHandle(), txObject.getEntityManagerHolder().getEntityManager());
            }
            catch (Exception ex) {
                this.logger.error((Object)"Could not close JDBC connection after transaction", (Throwable)ex);
            }
        }
        this.getJpaDialect().cleanupTransaction(txObject.getTransactionData());
        if (txObject.isNewEntityManagerHolder()) {
            EntityManager em = txObject.getEntityManagerHolder().getEntityManager();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Closing JPA EntityManager [" + em + "] after transaction"));
            }
            em.close();
        } else {
            this.logger.debug((Object)"Not closing pre-bound JPA EntityManager after transaction");
        }
    }

    private static class SuspendedResourcesHolder {
        private final EntityManagerHolder entityManagerHolder;
        private final ConnectionHolder connectionHolder;

        private SuspendedResourcesHolder(EntityManagerHolder emHolder, ConnectionHolder conHolder) {
            this.entityManagerHolder = emHolder;
            this.connectionHolder = conHolder;
        }

        private EntityManagerHolder getEntityManagerHolder() {
            return this.entityManagerHolder;
        }

        private ConnectionHolder getConnectionHolder() {
            return this.connectionHolder;
        }
    }

    private static class JpaTransactionObject
    extends JdbcTransactionObjectSupport {
        private EntityManagerHolder entityManagerHolder;
        private boolean newEntityManagerHolder;
        private Object transactionData;

        private JpaTransactionObject() {
        }

        public void setEntityManagerHolder(EntityManagerHolder entityManagerHolder, boolean newEntityManagerHolder) {
            this.entityManagerHolder = entityManagerHolder;
            this.newEntityManagerHolder = newEntityManagerHolder;
        }

        public EntityManagerHolder getEntityManagerHolder() {
            return this.entityManagerHolder;
        }

        public boolean isNewEntityManagerHolder() {
            return this.newEntityManagerHolder;
        }

        public boolean hasTransaction() {
            return this.entityManagerHolder != null && this.entityManagerHolder.getEntityManager() != null && this.entityManagerHolder.getEntityManager().getTransaction().isActive();
        }

        public void setTransactionData(Object transactionData) {
            this.transactionData = transactionData;
        }

        public Object getTransactionData() {
            return this.transactionData;
        }

        public void setRollbackOnly() {
            EntityTransaction tx = this.entityManagerHolder.getEntityManager().getTransaction();
            if (tx.isActive()) {
                tx.setRollbackOnly();
            }
            if (this.hasConnectionHolder()) {
                this.getConnectionHolder().setRollbackOnly();
            }
        }

        public boolean isRollbackOnly() {
            EntityTransaction tx = this.entityManagerHolder.getEntityManager().getTransaction();
            return tx.getRollbackOnly();
        }
    }
}

