/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import org.springsource.loaded.Constants;
import org.springsource.loaded.MethodMember;
import org.springsource.loaded.ReloadableType;
import org.springsource.loaded.TypeDescriptor;
import org.springsource.loaded.Utils;
import sl.org.objectweb.asm.Label;
import sl.org.objectweb.asm.MethodVisitor;

class ConstructorCopier
extends MethodVisitor
implements Constants {
    private static final int preInvokeSpecial = 0;
    private static final int postInvokeSpecial = 1;
    private int state = 0;
    private int unitializedObjectsCount = 0;
    private TypeDescriptor typeDescriptor;
    private String suffix;
    private String classname;

    public ConstructorCopier(MethodVisitor mv, TypeDescriptor typeDescriptor, String suffix, String classname) {
        super(327680, mv);
        this.typeDescriptor = typeDescriptor;
        this.suffix = suffix;
        this.classname = classname;
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (index == 0 && name.equals("this")) {
            super.visitLocalVariable("thiz", desc, signature, start, end, index);
        } else {
            super.visitLocalVariable(name, desc, signature, start, end, index);
        }
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    public void visitTypeInsn(int opcode, String type) {
        if (opcode == 187) {
            ++this.unitializedObjectsCount;
        }
        super.visitTypeInsn(opcode, type);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (opcode == 183 && name.charAt(0) == '<') {
            if (this.unitializedObjectsCount != 0) {
                --this.unitializedObjectsCount;
            } else if (this.state == 0) {
                if (owner.equals("java/lang/Object")) {
                    this.mv.visitInsn(87);
                } else {
                    String supertypename = this.typeDescriptor.getSupertypeName();
                    ReloadableType superRtype = this.typeDescriptor.getReloadableType().getTypeRegistry().getReloadableSuperType(supertypename);
                    if (superRtype == null) {
                        if (this.typeDescriptor.getReloadableType().getTypeRegistry().isReloadableTypeName(supertypename)) {
                            superRtype = this.typeDescriptor.getReloadableType().getTypeRegistry().getReloadableSuperType(supertypename);
                            throw new IllegalStateException("The supertype " + supertypename.replace('/', '.') + " has not been loaded as a reloadabletype");
                        }
                        Utils.insertPopsForAllParameters(this.mv, desc);
                        this.mv.visitInsn(87);
                    } else {
                        MethodMember existingCtor;
                        MethodMember methodMember = existingCtor = superRtype == null ? null : superRtype.getTypeDescriptor().getConstructor(desc);
                        if (existingCtor == null) {
                            Utils.collapseStackToArray(this.mv, desc);
                            this.mv.visitInsn(95);
                            this.mv.visitInsn(90);
                            this.mv.visitLdcInsn("<init>" + desc);
                            this.mv.visitMethodInsn(183, this.typeDescriptor.getSupertypeName(), "__execute", "([Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", false);
                            this.mv.visitInsn(87);
                        } else {
                            this.mv.visitMethodInsn(183, this.typeDescriptor.getSupertypeName(), "___init___", desc, false);
                        }
                    }
                }
                this.state = 1;
                return;
            }
        }
        if (opcode == 183 && name.charAt(0) != '<' && owner.equals(this.classname) && !name.startsWith("r$")) {
            String descriptor = Utils.insertExtraParameter(owner, desc);
            super.visitMethodInsn(184, Utils.getExecutorName(this.classname, this.suffix), name, descriptor, false);
        } else {
            MethodMember mm;
            boolean done = false;
            if (opcode == 184 && (mm = this.typeDescriptor.getByDescriptor(name, desc)) != null && mm.isPrivate()) {
                super.visitMethodInsn(184, Utils.getExecutorName(this.classname, this.suffix), name, desc, false);
                done = true;
            }
            if (!done) {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }
    }
}

