/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.sync;

import difflib.Delta;
import difflib.DiffUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.springframework.sync.AddOperation;
import org.springframework.sync.Patch;
import org.springframework.sync.PatchException;
import org.springframework.sync.PatchOperation;
import org.springframework.sync.RemoveOperation;
import org.springframework.sync.ReplaceOperation;
import org.springframework.sync.TestOperation;
import org.springframework.util.ObjectUtils;

public class Diff {
    public static Patch diff(Object original, Object modified) throws PatchException {
        try {
            ArrayList<PatchOperation> operations = new ArrayList<PatchOperation>();
            if (original instanceof List && modified instanceof List) {
                Diff.diffList(operations, "", (List)original, (List)modified);
            } else {
                Diff.diffNonList(operations, "", original, modified);
            }
            return new Patch(operations);
        }
        catch (Exception e) {
            throw new PatchException("Error performing diff:", e);
        }
    }

    private static void diffList(List<PatchOperation> operations, String path, List<?> original, List<?> modified) throws IOException, IllegalAccessException {
        difflib.Patch diff = DiffUtils.diff(original, modified);
        List deltas = diff.getDeltas();
        for (Delta delta : deltas) {
            Object originalObject;
            int offset;
            List lines;
            Delta.TYPE type = delta.getType();
            int revisedPosition = delta.getRevised().getPosition();
            if (type == Delta.TYPE.CHANGE) {
                lines = delta.getRevised().getLines();
                for (offset = 0; offset < lines.size(); ++offset) {
                    originalObject = original.get(revisedPosition + offset);
                    Object revisedObject = modified.get(revisedPosition + offset);
                    Diff.diffNonList(operations, path + "/" + (revisedPosition + offset), originalObject, revisedObject);
                }
                continue;
            }
            if (type == Delta.TYPE.INSERT) {
                lines = delta.getRevised().getLines();
                for (offset = 0; offset < lines.size(); ++offset) {
                    operations.add(new AddOperation(path + "/" + (revisedPosition + offset), lines.get(offset)));
                }
                continue;
            }
            if (type != Delta.TYPE.DELETE) continue;
            lines = delta.getOriginal().getLines();
            for (offset = 0; offset < lines.size(); ++offset) {
                originalObject = original.get(revisedPosition + offset);
                operations.add(new TestOperation(path + "/" + revisedPosition, originalObject));
                operations.add(new RemoveOperation(path + "/" + revisedPosition));
            }
        }
    }

    private static void diffNonList(List<PatchOperation> operations, String path, Object original, Object modified) throws IOException, IllegalAccessException {
        if (!ObjectUtils.nullSafeEquals((Object)original, (Object)modified)) {
            Field[] fields;
            if (modified == null) {
                operations.add(new RemoveOperation(path));
                return;
            }
            if (Diff.isPrimitive(modified)) {
                operations.add(new TestOperation(path, original));
                if (original == null) {
                    operations.add(new AddOperation(path, modified));
                } else {
                    operations.add(new ReplaceOperation(path, modified));
                }
                return;
            }
            Class<?> originalType = original.getClass();
            for (Field field : fields = originalType.getDeclaredFields()) {
                field.setAccessible(true);
                Object origValue = field.get(original);
                Object modValue = field.get(modified);
                Diff.diffNonList(operations, path + "/" + field.getName(), origValue, modValue);
            }
        }
    }

    private static boolean isPrimitive(Object o) {
        return o instanceof String || o instanceof Number || o instanceof Boolean;
    }
}

