/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.sync;

import java.util.List;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionException;
import org.springframework.sync.LateObjectEvaluator;
import org.springframework.sync.PatchException;
import org.springframework.sync.PathToSpEL;

public abstract class PatchOperation {
    protected final String op;
    protected final String path;
    protected final Object value;
    protected final Expression spelExpression;

    public PatchOperation(String op, String path) {
        this(op, path, null);
    }

    public PatchOperation(String op, String path, Object value) {
        this.op = op;
        this.path = path;
        this.value = value;
        this.spelExpression = PathToSpEL.pathToExpression(path);
    }

    public String getOp() {
        return this.op;
    }

    public String getPath() {
        return this.path;
    }

    public Object getValue() {
        return this.value;
    }

    protected Object popValueAtPath(Object target, String removePath) {
        Integer listIndex = this.targetListIndex(removePath);
        Expression expression = PathToSpEL.pathToExpression(removePath);
        Object value = expression.getValue(target);
        if (listIndex == null) {
            try {
                expression.setValue(target, null);
                return value;
            }
            catch (NullPointerException e) {
                throw new PatchException("Path '" + removePath + "' is not nullable.");
            }
        }
        Expression parentExpression = PathToSpEL.pathToParentExpression(removePath);
        List list = (List)parentExpression.getValue(target);
        list.remove(listIndex >= 0 ? listIndex : list.size() - 1);
        return value;
    }

    protected void addValue(Object target, Object value) {
        Expression parentExpression = PathToSpEL.pathToParentExpression(this.path);
        Object parent = parentExpression != null ? parentExpression.getValue(target) : null;
        Integer listIndex = this.targetListIndex(this.path);
        if (parent == null || !(parent instanceof List) || listIndex == null) {
            this.spelExpression.setValue(target, value);
        } else {
            List list = (List)parentExpression.getValue(target);
            int addAtIndex = listIndex >= 0 ? listIndex.intValue() : list.size();
            list.add(addAtIndex, value);
        }
    }

    protected void setValueOnTarget(Object target, Object value) {
        this.spelExpression.setValue(target, value);
    }

    protected Object getValueFromTarget(Object target) {
        try {
            return this.spelExpression.getValue(target);
        }
        catch (ExpressionException e) {
            throw new PatchException("Unable to get value from target", (Exception)((Object)e));
        }
    }

    protected <T> Object evaluateValueFromTarget(Object targetObject, Class<T> entityType) {
        return this.value instanceof LateObjectEvaluator ? ((LateObjectEvaluator)this.value).evaluate(entityType) : this.value;
    }

    abstract <T> void perform(Object var1, Class<T> var2);

    private Integer targetListIndex(String path) {
        String[] pathNodes = path.split("\\/");
        String lastNode = pathNodes[pathNodes.length - 1];
        if ("~".equals(lastNode)) {
            return -1;
        }
        try {
            return Integer.parseInt(lastNode);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

