/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.sync.diffsync;

import java.util.List;
import org.springframework.sync.Diff;
import org.springframework.sync.Patch;
import org.springframework.sync.diffsync.ShadowStore;
import org.springframework.sync.util.DeepCloneUtils;

public class DiffSync<T> {
    private ShadowStore shadowStore;
    private Class<T> entityType;

    public DiffSync(ShadowStore shadowStore, Class<T> entityType) {
        this.shadowStore = shadowStore;
        this.entityType = entityType;
    }

    public T apply(Patch patch, T target) {
        if (patch.size() == 0) {
            return target;
        }
        T shadow = this.getShadow(target);
        shadow = patch.apply(shadow, this.entityType);
        this.putShadow(shadow);
        return patch.apply(DeepCloneUtils.deepClone(target), this.entityType);
    }

    public List<T> apply(Patch patch, List<T> target) {
        if (patch.size() == 0) {
            return target;
        }
        List<T> shadow = this.getShadow(target);
        shadow = patch.apply(shadow, this.entityType);
        this.putShadow(shadow);
        return patch.apply(DeepCloneUtils.deepClone(target), this.entityType);
    }

    public Patch diff(T target) {
        T shadow = this.getShadow(target);
        Patch diff = Diff.diff(shadow, target);
        this.putShadow(diff.apply(shadow, this.entityType));
        return diff;
    }

    public Patch diff(List<T> target) {
        List<T> shadow = this.getShadow(target);
        Patch diff = Diff.diff(shadow, target);
        this.putShadow(diff.apply(shadow, this.entityType));
        return diff;
    }

    private T getShadow(T target) {
        String shadowStoreKey = this.getShadowStoreKey(target);
        Object shadow = this.shadowStore.getShadow(shadowStoreKey);
        if (shadow == null) {
            shadow = DeepCloneUtils.deepClone(target);
        }
        return (T)shadow;
    }

    private void putShadow(T shadow) {
        String shadowStoreKey = this.getShadowStoreKey(shadow);
        this.shadowStore.putShadow(shadowStoreKey, shadow);
    }

    private List<T> getShadow(List<T> target) {
        String shadowStoreKey = this.getShadowStoreKey(target);
        List<T> shadow = (List<T>)this.shadowStore.getShadow(shadowStoreKey);
        if (shadow == null) {
            shadow = DeepCloneUtils.deepClone(target);
        }
        return shadow;
    }

    private void putShadow(List<T> shadow) {
        String shadowStoreKey = this.getShadowStoreKey(shadow);
        this.shadowStore.putShadow(shadowStoreKey, shadow);
    }

    private String getShadowStoreKey(Object o) {
        String resourceName = this.entityType.getSimpleName();
        if (o instanceof List) {
            return "shadow/list/" + resourceName;
        }
        return "shadow/" + resourceName;
    }
}

