/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.sync.diffsync;

import java.lang.reflect.Field;
import org.springframework.sync.diffsync.Equivalency;
import org.springframework.util.ObjectUtils;

public class IdPropertyEquivalency
implements Equivalency {
    @Override
    public boolean isEquivalent(Object o1, Object o2) {
        try {
            Field idField1 = o1.getClass().getDeclaredField("id");
            idField1.setAccessible(true);
            Object id1 = idField1.get(o1);
            Field idField2 = o2.getClass().getDeclaredField("id");
            idField2.setAccessible(true);
            Object id2 = idField2.get(o2);
            return ObjectUtils.nullSafeEquals((Object)id1, (Object)id2);
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }
}

