/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.sync.diffsync.config;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.sync.diffsync.MapBasedShadowStore;
import org.springframework.sync.diffsync.PersistenceCallbackRegistry;
import org.springframework.sync.diffsync.ShadowStore;
import org.springframework.sync.diffsync.config.DiffSyncConfigurer;
import org.springframework.sync.diffsync.web.DiffSyncController;
import org.springframework.util.Assert;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
public class DifferentialSynchronizationRegistrar
extends WebMvcConfigurerAdapter {
    private List<DiffSyncConfigurer> diffSyncConfigurers;

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        ArrayList<MappingJackson2HttpMessageConverter> messageConverters = new ArrayList<MappingJackson2HttpMessageConverter>();
        messageConverters.add(new MappingJackson2HttpMessageConverter());
    }

    @Autowired
    public void setDiffSyncConfigurers(List<DiffSyncConfigurer> diffSyncConfigurers) {
        Assert.notNull(diffSyncConfigurers, (String)"At least one configuration class must implement DiffSyncConfigurer");
        Assert.notEmpty(diffSyncConfigurers, (String)"At least one configuration class must implement DiffSyncConfigurer");
        this.diffSyncConfigurers = diffSyncConfigurers;
    }

    @Bean
    @Scope(value="session", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public ShadowStore shadowStore(HttpSession session) {
        for (DiffSyncConfigurer diffSyncConfigurer : this.diffSyncConfigurers) {
            ShadowStore shadowStore = diffSyncConfigurer.getShadowStore(session.getId());
            if (shadowStore == null) continue;
            return shadowStore;
        }
        return new MapBasedShadowStore(session.getId());
    }

    @Bean
    public PersistenceCallbackRegistry persistenceCallbackRegistry() {
        PersistenceCallbackRegistry registry = new PersistenceCallbackRegistry();
        for (DiffSyncConfigurer diffSyncConfigurer : this.diffSyncConfigurers) {
            diffSyncConfigurer.addPersistenceCallbacks(registry);
        }
        return registry;
    }

    @Bean
    public DiffSyncController diffSyncController(PersistenceCallbackRegistry callbackRegistry, ShadowStore shadowStore) {
        return new DiffSyncController(callbackRegistry, shadowStore);
    }
}

