/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.sync.diffsync.web;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.sync.Patch;
import org.springframework.sync.PatchException;
import org.springframework.sync.diffsync.DiffSync;
import org.springframework.sync.diffsync.Equivalency;
import org.springframework.sync.diffsync.IdPropertyEquivalency;
import org.springframework.sync.diffsync.PersistenceCallback;
import org.springframework.sync.diffsync.PersistenceCallbackRegistry;
import org.springframework.sync.diffsync.ShadowStore;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DiffSyncController {
    private ShadowStore shadowStore;
    private PersistenceCallbackRegistry callbackRegistry;
    private Equivalency equivalency = new IdPropertyEquivalency();

    @Autowired
    public DiffSyncController(PersistenceCallbackRegistry callbackRegistry, ShadowStore shadowStore) {
        this.callbackRegistry = callbackRegistry;
        this.shadowStore = shadowStore;
    }

    @RequestMapping(value={"${spring.diffsync.path:}/{resource}"}, method={RequestMethod.PATCH})
    public Patch patch(@PathVariable(value="resource") String resource, @RequestBody Patch patch, HttpSession session) throws PatchException {
        PersistenceCallback<?> persistenceCallback = this.callbackRegistry.findPersistenceCallback(resource);
        return this.applyAndDiff(patch, persistenceCallback.findAll(), persistenceCallback);
    }

    @RequestMapping(value={"${spring.diffsync.path:}/{resource}/{id}"}, method={RequestMethod.PATCH})
    public Patch patch(@PathVariable(value="resource") String resource, @PathVariable(value="id") String id, @RequestBody Patch patch, HttpSession session) throws PatchException {
        PersistenceCallback<?> persistenceCallback = this.callbackRegistry.findPersistenceCallback(resource);
        Object findOne = persistenceCallback.findOne(id);
        return this.applyAndDiff2(patch, findOne, persistenceCallback);
    }

    @ExceptionHandler(value={PatchException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT, reason="Unable to apply patch")
    public void handlePatchException(PatchException e) {
    }

    private <T> Patch applyAndDiff2(Patch patch, Object target, PersistenceCallback<T> persistenceCallback) {
        if (target instanceof List) {
            return this.applyAndDiff(patch, (List)target, persistenceCallback);
        }
        DiffSync<Object> sync = new DiffSync<Object>(this.shadowStore, persistenceCallback.getEntityType());
        Object patched = sync.apply(patch, target);
        persistenceCallback.persistChange(patched);
        return sync.diff(patched);
    }

    private <T> Patch applyAndDiff(Patch patch, List<T> target, PersistenceCallback<T> persistenceCallback) {
        DiffSync<T> sync = new DiffSync<T>(this.shadowStore, persistenceCallback.getEntityType());
        List<T> patched = sync.apply(patch, target);
        ArrayList<T> itemsToSave = new ArrayList<T>(patched);
        itemsToSave.removeAll(target);
        ArrayList<T> itemsToDelete = new ArrayList<T>(target);
        block0: for (T candidate : target) {
            for (T item : patched) {
                if (!this.equivalency.isEquivalent(candidate, item)) continue;
                itemsToDelete.remove(candidate);
                continue block0;
            }
        }
        persistenceCallback.persistChanges(itemsToSave, itemsToDelete);
        return sync.diff(patched);
    }
}

