/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.sync.diffsync.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.sync.Patch;
import org.springframework.sync.json.JsonPatchMaker;

public class JsonPatchHttpMessageConverter
extends AbstractHttpMessageConverter<Patch> {
    private static final MediaType JSON_PATCH = new MediaType("application", "json-patch+json");
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private JsonPatchMaker jsonPatchMaker;

    public JsonPatchHttpMessageConverter() {
        this.setSupportedMediaTypes(Arrays.asList(JSON_PATCH));
        this.jsonPatchMaker = new JsonPatchMaker();
    }

    protected boolean supports(Class<?> clazz) {
        return Patch.class.isAssignableFrom(clazz);
    }

    protected Patch readInternal(Class<? extends Patch> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        return this.jsonPatchMaker.fromJsonNode(MAPPER.readTree(inputMessage.getBody()));
    }

    protected void writeInternal(Patch patch, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        outputMessage.getHeaders().setContentType(JSON_PATCH);
        MAPPER.writer().writeValue(outputMessage.getBody(), (Object)this.jsonPatchMaker.toJsonNode(patch));
    }
}

