/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.sync.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.sync.LateObjectEvaluator;

class JsonLateObjectEvaluator
implements LateObjectEvaluator {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private JsonNode valueNode;

    public JsonLateObjectEvaluator(JsonNode valueNode) {
        this.valueNode = valueNode;
    }

    @Override
    public <T> Object evaluate(Class<T> type) {
        try {
            return MAPPER.readValue(this.valueNode.traverse(), type);
        }
        catch (Exception e) {
            return null;
        }
    }
}

